ORCA/M Asm65816 2.1.0

0001 1AE7                       title 'SANE         FP816         GS ROM 3.0' 
0002 1AE7              ****************************************************************
0003 1AE7              *                                                              *
0004 1AE7              *                      SANE FP816                              *
0005 1AE7              *                                                              *
0006 1AE7              ****************************************************************
0007 1AE7
0008 1AE7
0009 1AE7              ****************************************************************
0010 1AE7              *                                                              *
0011 1AE7              *                   Copyright (C) 1985-1988                    *
0012 1AE7              *                   All Rights Reserved                        *
0013 1AE7              *                   Apple Computer, Inc.                       *
0014 1AE7              *                                                              *
0015 1AE7              ****************************************************************
0016 1AE7
0017 1AE7
0018 1AE7
0019 1AE7              **********************************************************************
0020 1AE7              *
0021 1AE7              * Change History
0022 1AE7              *
0023 1AE7              * 12 Dec 88         Kenton Hanson
0024 1AE7              *
0025 1AE7              * Fixed Nan codes (NAN comp and NAN zero).
0026 1AE7              * Fixed conversion error for large comps to exended (in Unpack).
0027 1AE7              * Fixed error signaling error in Floating point NAN converting to
0028 1AE7              *       COMP NAN.
0029 1AE7              *
0030 1AE7              **********************************************************************
0031 1AE7
0032 1AE7                       string asis 
0033 1AE7                       blanks off 
0034 1AE7
0035 1AE7                       include 'all.macros' 
0036 1AE7                       include '::sys.equs.asm' 
0037 1AE7                       include 'sane.macros' 
0038 1AE7
0039 1AE7              SaneVersionNumber equ   $0300
0040 1AE7              True     equ   $FFFF
0041 1AE7              False    equ   $0000
0042 1AE7
0043 1AE7              ;-----------------------------------------------
0044 1AE7              ;
0045 1AE7              ;   Imported addresses
0046 1AE7              ;
0047 1AE7              ;-----------------------------------------------
0048 1AE7
0049 1AE7                       IMPORT oEndCall0 
0050 1AE7                       IMPORT oEndCall2 
0051 1AE7                       IMPORT Elems816 
0052 1AE7
0053 1AE7              ;-----------------------------------------------
0054 1AE7              ;
0055 1AE7              ;   Forward addresses and entries
0056 1AE7              ;
0057 1AE7              ;-----------------------------------------------
0058 1AE7                       ENTRY AtoC
0059 1AE7                       ENTRY BtoA
0060 1AE7                       ENTRY BtoC
0061 1AE7                       ENTRY BtoE
0062 1AE7                       ENTRY BtoX
0063 1AE7                       ENTRY CtoB
0064 1AE7                       ENTRY CtoX
0065 1AE7                       ENTRY EtoA
0066 1AE7                       ENTRY EtoB
0067 1AE7                       ENTRY XtoA
0068 1AE7                       ENTRY XtoB
0069 1AE7
0070 1AE7                       ENTRY CStr2Dec
0071 1AE7                       ENTRY Dec2Str
0072 1AE7                       ENTRY DecStr
0073 1AE7                       ENTRY DnrmC
0074 1AE7                       ENTRY Eight16
0075 1AE7                       ENTRY NrmlzC
0076 1AE7                       ENTRY Rnd2Int
0077 1AE7                       ENTRY SaneShutdown
0078 1AE7                       ENTRY SaneStartup
0079 1AE7                       ENTRY SaneStatus
0080 1AE7                       ENTRY SaneVersion
0081 1AE7                       ENTRY ScaleIt
0082 1AE7                       ENTRY Str2Dec
0083 1AE7                       ENTRY TrpHd1
0084 1AE7                       ENTRY UnPck
0085 1AE7                       ENTRY XitFP
0086 1AE7                       ENTRY add
0087 1AE7                       ENTRY ck4URO
0088 1AE7                       ENTRY mul
0089 1AE7                       ENTRY pck
0090 1AE7                       ENTRY rtnA
0091 1AE7                       ENTRY rtnInf
0092 1AE7                       ENTRY setXcpn
0093 1AE7                       ENTRY sqrt
0094 1AE7                       ENTRY sub
0095 1AE7                       ENTRY B2D
0096 1AE7                       ENTRY D2B
0097 1AE7                       ENTRY Xdiv
0098 1AE7                       ENTRY REM
0099 1AE7
0100 1AE7              ;                copy sane/oequs
0101 1AE7              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0102 1AE7              ;; File:  FPEques
0103 1AE7              ;; Description: Equs for ORCA SANE 65816 floating point engine.
0104 1AE7              ;; Status: Alpha
0105 1AE7              ;;
0106 1AE7              ;; Written by Kenton Hanson, Apple Numerics Group, 12 May 1986
0107 1AE7              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0108 1AE7              ZPrtn    equ   0
0109 1AE7              OrigDirect equ   ZPrtn+6
0110 1AE7              OrigBank equ   OrigDirect+2
0111 1AE7              base1    equ   OrigBank+2               ;10
0112 1AE7              opword   equ   base1
0113 1AE7              CRgstr   equ   base1+2
0114 1AE7              BRgstr   equ   base1+6
0115 1AE7              ARgstr   equ   base1+10
0116 1AE7              HaltVect equ   base1+14
0117 1AE7              EnvWrd   equ   base1+18
0118 1AE7              tmpFlgs  equ   base1+20
0119 1AE7              pendingX equ   base1+22
0120 1AE7              pendingY equ   base1+24
0121 1AE7              TmpZP    equ   base1+26                 ;36
0122 1AE7              TmpZP2   equ   TmpZP+2
0123 1AE7              TmpZP3   equ   TmpZP+4
0124 1AE7              TmpZP4   equ   TmpZP+6
0125 1AE7              TmpZP5   equ   TmpZP+8
0126 1AE7              fence    equ   TmpZP+10
0127 1AE7              fence2   equ   TmpZP+12
0128 1AE7              fenceSV  equ   TmpZP+14
0129 1AE7              SBWord   equ   TmpZP+16                 ;Max (Sticky Bit Word, length 2nd argument)
0130 1AE7              opcode   equ   TmpZP+18
0131 1AE7              ZeroWord equ   TmpZP+20
0132 1AE7              atag     equ   TmpZP+22                 ;identification tag             (word) 58
0133 1AE7              signA    equ   atag+2                   ;sign                           (word)
0134 1AE7              expnA    equ   atag+4                   ;unbiased exponent              (Long)
0135 1AE7              lgthA    equ   atag+8                   ;length of Fraction in bytes    (word)
0136 1AE7              btag     equ   atag+10                  ;identification tag             (word)
0137 1AE7              signB    equ   btag+2                   ;sign                           (word)
0138 1AE7              expnB    equ   btag+4                   ;unbiased exponent              (Long)
0139 1AE7              lgthB    equ   btag+8                   ;length of Fraction in bytes    (word)
0140 1AE7              ctag     equ   atag+20                  ;identification tag             (word)
0141 1AE7              signC    equ   ctag+2                   ;sign                           (word)
0142 1AE7              expnC    equ   ctag+4                   ;unbiased exponent              (Long)
0143 1AE7              lgthC    equ   ctag+8                   ;length of Fraction in bytes    (word)
0144 1AE7              FrctA    equ   atag+30                  ; 88
0145 1AE7              FrctB    equ   FrctA+26
0146 1AE7              FrctC    equ   FrctA+52
0147 1AE7              len      equ   FrctA+78                 ; 166
0148 1AE7              ilog     equ   len+2
0149 1AE7              iscale   equ   len+4
0150 1AE7              style    equ   len+6
0151 1AE7              digits   equ   len+8
0152 1AE7              etag     equ   len+10                   ;identification tag             (word) 176
0153 1AE7              signE    equ   etag+2                   ;sign                           (word)
0154 1AE7              expnE    equ   etag+4                   ;unbiased exponent              (Long)
0155 1AE7              lgthE    equ   etag+8                   ;length of Fraction in bytes    (word)
0156 1AE7              xtag     equ   len+20                   ;identification tag             (word)
0157 1AE7              signX    equ   xtag+2                   ;sign                           (word)
0158 1AE7              expnX    equ   xtag+4                   ;unbiased exponent              (Long)
0159 1AE7              lgthX    equ   xtag+8                   ;length of Fraction in bytes    (word)
0160 1AE7              FrctE    equ   len+30                   ;fraction with binary point after first bit
0161 1AE7              FrctX    equ   len+56                   ;fraction with binary point after first bit
0162 1AE7              ffExt    equ   0
0163 1AE7              ffDbl    equ   2
0164 1AE7              ffSgl    equ   4
0165 1AE7              ffLng    equ   6
0166 1AE7              ffInt    equ   8
0167 1AE7              ffComp   equ   10
0168 1AE7              ffq      equ   12
0169 1AE7              ffqq     equ   14
0170 1AE7              DnrmTag  equ   1
0171 1AE7              ZeroTag  equ   -1
0172 1AE7              InfTag   equ   -2
0173 1AE7              NanTag   equ   -3
0174 1AE7              SNanTag  equ   -4
0175 1AE7              invxcp   equ   01
0176 1AE7              unfxcp   equ   02
0177 1AE7              ovfxcp   equ   04
0178 1AE7              dvzxcp   equ   08
0179 1AE7              inexcp   equ   $10
0180 1AE7              NanSqrt  equ   $4001
0181 1AE7              NanAdd   equ   $4002
0182 1AE7              NanDiv   equ   $4004
0183 1AE7              NanMlt   equ   $4008
0184 1AE7              NanRem   equ   $4009
0185 1AE7              NaNAscB  equ   $4011
0186 1AE7              NaNComp  equ   $4014                    ; error codes corrected 12 Dec 88 by Kenton
0187 1AE7              NaNZero  equ   $4015                    ; ibid
0188 1AE7              BgnSgDg  equ   4
0189 1AE7              SigDigLn equ   28                       ;28 ???
0190 1AE7
0191 1AE7              ;          copy sane/call.table
0192 1AE7                       EXPORT SaneCallTable 
0193 1AE7              SaneCallTable PROC 
0194 1AE7
0195 1AE7 0C 00 00 00           DC L:(TheEnd-SaneCallTable)/4
0196 1AEB DE FB FE 00           DC L:oEndCall0-1               ; jumps direct 29 dec 86
0197 1AEF 16 1B FC 00           DC L:SaneStartup-1
0198 1AF3 36 1B FC 00           DC L:SaneShutdown-1
0199 1AF7 4D 1B FC 00           DC L:SaneVersion-1
0200 1AFB DE FB FE 00           DC L:oEndCall0-1               ; jumps direct 29 dec 86
0201 1AFF 56 1B FC 00           DC L:SaneStatus-1              ; added 29 dec 86 by SEG
0202 1B03 DE FB FE 00           DC L:oEndCall0-1
0203 1B07 DE FB FE 00           DC L:oEndCall0-1
0204 1B0B
0205 1B0B E6 1B FC 00           DC L:Eight16-1
0206 1B0F 8C 31 FC 00           DC L:DecStr-1
0207 1B13 5A 37 FC 00           DC L:Elems816-1
0208 1B17
0209 1B17              TheEnd                                  ; 
0210 1B17
0211 1B17                       ENDP 
0212 1B17              ;          copy sane/init.calls
0213 1B17              *****************************************************************
0214 1B17              *
0215 1B17              * SaneBootInit
0216 1B17              *
0217 1B17              * Since this does nothing, I put the address of oEndCall0
0218 1B17              * in the call table.
0219 1B17              *
0220 1B17              *****************************************************************
0221 1B17
0222 1B17
0223 1B17              *****************************************************************
0224 1B17              *
0225 1B17              * SaneStartup
0226 1B17              *
0227 1B17              *****************************************************************
0228 1B17                       EXPORT SaneStartup 
0229 1B17              SaneStartup PROC 
0230 1B17              RTL1     equ   1
0231 1B17              RTL2     equ   RTL1+3
0232 1B17              ZPToUse  equ   RTL2+3
0233 1B17 A3 07                 lda   ZPToUse,s
0234 1B19 0B                    phd                            ; temp store current d
0235 1B1A 5B                    tcd                            ; set d to SANE value
0236 1B1B 64 18                 stz   HaltVect                 ; set default env and HV
0237 1B1D 64 1A                 stz   HaltVect+2
0238 1B1F 64 1C                 stz   EnvWrd
0239 1B21 2B                    pld                            ; restore current d
0240 1B22 F4 00 00              PushWord #0                    ; system call
0241 1B25 F4 0A 00              PushWord #10                   ; tool set number
0242 1B28 F4 00 00              PushWord #0                    ; High byte of WAP
0243 1B2B 48                    pha   
0244 1B2C A2 01 0D 22           _SetWAP 
0245 1B33
0246 1B33 5C F7 FB FE           jml   oEndCall2
0247 1B37
0248 1B37                       ENDP 
0249 1B37
0250 1B37              *****************************************************************
0251 1B37              *
0252 1B37              * SaneShutdown
0253 1B37              *
0254 1B37              *****************************************************************
0255 1B37                       EXPORT SaneShutdown 
0256 1B37              SaneShutdown PROC 
0257 1B37
0258 1B37 F4 00 00              PushWord #0 
0259 1B3A F4 0A 00              PushWord #10 
0260 1B3D F4 00 00 F4           PushLong #0 
0261 1B43 A2 01 0D 22           _SetWAP 
0262 1B4A
0263 1B4A
0264 1B4A 5C DF FB FE           jml   oEndCall0
0265 1B4E
0266 1B4E                       ENDP 
0267 1B4E
0268 1B4E              *****************************************************************
0269 1B4E              *
0270 1B4E              * SaneVersion
0271 1B4E              *
0272 1B4E              * Uses global version number equate.
0273 1B4E              *
0274 1B4E              *****************************************************************
0275 1B4E                       EXPORT SaneVersion 
0276 1B4E              SaneVersion PROC 
0277 1B4E              RTL1     equ   1
0278 1B4E              RTL2     equ   RTL1+3
0279 1B4E              VersionInfo equ   RTL2+3
0280 1B4E
0281 1B4E
0282 1B4E A9 00 03              lda   #SaneVersionNumber
0283 1B51
0284 1B51
0285 1B51                       EXPORT ShareSTATUS 
0286 1B51              ShareSTATUS                             ;       
0287 1B51 83 07                 sta   VersionInfo,s
0288 1B53 5C DF FB FE           jml   oEndCall0
0289 1B57
0290 1B57                       ENDP 
0291 1B57
0292 1B57
0293 1B57              *****************************************************************
0294 1B57              *
0295 1B57              * SaneSTATUS
0296 1B57              *
0297 1B57              * Added by SEG on 29 Dec 86
0298 1B57              *
0299 1B57              *****************************************************************
0300 1B57                       EXPORT SaneStatus 
0301 1B57              SaneStatus PROC 
0302 1B57
0303 1B57 C9 00 00              cmp   #0
0304 1B5A F0 F5                 beq   ShareStatus
0305 1B5C A9 FF FF              lda   #True
0306 1B5F 80 F0                 bra   ShareStatus
0307 1B61
0308 1B61                       ENDP 
0309 1B61
0310 1B61
0311 1B61              *****************************************************************
0312 1B61              *
0313 1B61              * SaneReset
0314 1B61              *
0315 1B61              * Since this does nothing, I put the address of oEndCall0
0316 1B61              * in the call table.
0317 1B61              *
0318 1B61              *****************************************************************
0319 1B61              ;          copy sane/dt
0320 1B61              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0321 1B61              ;; File:  DT
0322 1B61              ;; Description: Data Constants for ORCA SANE 65816 floating point engine
0323 1B61              ;; Status: Alpha
0324 1B61              ;;
0325 1B61              ;; Written by Kenton Hanson, Apple Numerics Group, 13 May 1986
0326 1B61              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0327 1B61                       EXPORT DT 
0328 1B61              DT       PROC 
0329 1B61                       EXPORT lastW 
0330 1B61 08 00 06 00  lastW    DC W:8,6,2,2,0,6,24,12         ;ext, dbl, sgl, Lng, int, comp, q, q*
0331 1B71                       EXPORT lastSig 
0332 1B71 06 00 06 00  lastSig  DC W:6,6,2,2,0,6,22,10
0333 1B81                       EXPORT StkBtWd 
0334 1B81 08 00 06 00  StkBtWd  DC W:8,6,2,4,2,8,24,12
0335 1B91                       EXPORT ShftDS 
0336 1B91 04 00 07 00  ShftDS   DC W:4,7                       ;right bit shift for word align Dbl+Sgl
0337 1B95                       EXPORT ExpAdj 
0338 1B95 00 3C 80 3F  ExpAdj   DC W:15360,16256               ;2^14 - 2^10, 2^14 - 2^7
0339 1B99                       EXPORT MaxExp 
0340 1B99 FF FF FF 07  MaxExp   DC W:-1,2047,255
0341 1B9F                       EXPORT MinExp 
0342 1B9F 00 00 01 3C  MinExp   DC W:0,15361,16257,16414,16398,16446,0
0343 1BAD                       EXPORT MaxShft 
0344 1BAD 42 00 37 00  MaxShft  DC W:66,55,26,34,18,66,98,98
0345 1BBD                       EXPORT MaxAdj 
0346 1BBD FF 7F FF 43  MaxAdj   DC W:32767,17407,16511,16414,16398,16446,32767
0347 1BCB                       EXPORT ZINS 
0348 1BCB 30 49 4E 4E  ZINS     DC B:'0INN'
0349 1BCF                       EXPORT RndTbl 
0350 1BCF 00 00 00 C0  RndTbl   DC B:$00,$00,$00,$c0,$00,$c0,$00,$00,$00,$00,$00,$c0,$00,$c0,$00,$00,$00,$40,$00,$40,$00,$80,$00,$80
0351 1BE7                       ENDP 
0352 1BE7              ;          copy sane/fp816
0353 1BE7              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0354 1BE7              ;; File:  FP816
0355 1BE7              ;; Description: Main routine for ORCA SANE 65816 floating point engine.
0356 1BE7              ;; Status: Release 2.0
0357 1BE7              ;;
0358 1BE7              ;; Written by Kenton Hanson, Apple Numerics Group, 19 May 1986
0359 1BE7              ;;
0360 1BE7              ;; Modification History: 11Aug86 klh Halt vector mechanism fixed
0361 1BE7              ;;                       26Feb87 klh Sets Invalid on integer overflow
0362 1BE7              ;;
0363 1BE7              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0364 1BE7                       EXPORT Eight16 
0365 1BE7              Eight16  PROC 
0366 1BE7 22 64 00 E1           jsl   IncBusyFlg
0367 1BEB 0B                    phd                            ; put direct reg on stack
0368 1BEC 5B                    tcd                            ; set direct reg
0369 1BED 68                    pla                            ; save orig direct on zp
0370 1BEE 85 06                 sta   OrigDirect
0371 1BF0 8B                    phb                            ; save original data bank register
0372 1BF1 8B                    phb   
0373 1BF2 68                    pla   
0374 1BF3 85 08                 sta   OrigBank                 ; on zero page
0375 1BF5 4B                    phk                            ; set data bank register
0376 1BF6 AB                    plb                            ; this bank
0377 1BF7 80 04                 bra   PassClayton
0378 1BF9                       EXPORT Clayton 
0379 1BF9              Clayton                                 ;       ;entry for Elems code
0380 1BF9 22 64 00 E1           jsl   IncBusyFlg
0381 1BFD                       EXPORT PassClayton 
0382 1BFD              PassClayton                             ; 
0383 1BFD 68                    pla   
0384 1BFE 85 00                 sta   ZPRtn
0385 1C00 68                    pla   
0386 1C01 85 02                 sta   ZPRtn+2
0387 1C03 68                    pla   
0388 1C04 85 04                 sta   ZPRtn+4
0389 1C06 64 38                 stz   ZeroWord                 ;initialize ZeroWord
0390 1C08 64 1E                 stz   tmpFlgs                  ;initialize tmpFlgs
0391 1C0A 64 4E                 stz   Ctag                     ;initialize Ctag
0392 1C0C 64 50                 stz   signC                    ;initialize signC
0393 1C0E 68                    pla   
0394 1C0F 85 0A                 sta   opword                   ;save opword
0395 1C11 EB                    xba   
0396 1C12 A8                    tay   
0397 1C13 29 07 00              and   #$7                      ;location of source format
0398 1C16 0A                    asl   a                        ;double it, for word based tables
0399 1C17 85 2E                 sta   fence                    ;store source format (usually)
0400 1C19 AA                    tax                            ;also store in 'x'
0401 1C1A 98                    tya   
0402 1C1B 29 70 00              and   #$70                     ;location of destination format
0403 1C1E F0 03                 beq   z1s1
0404 1C20 4A                    lsr   a
0405 1C21 4A                    lsr   a
0406 1C22 4A                    lsr   a
0407 1C23 85 30        z1s1     sta   fence2                   ;format of destination
0408 1C25 A5 0A                 lda   opword
0409 1C27 29 1F 00              and   #$1f                     ;mask out opcode
0410 1C2A 85 36                 sta   opcode
0411 1C2C A8                    tay                            ;also store in 'y' for NonArith table2
0412 1C2D 4A                    lsr   a                        ;odd values are non Arithmetic opcodes
0413 1C2E 90 05                 bcc   z1s2                     ;Arithmetic function
0414 1C30 B9 DB 1C              lda   table2-1,y
0415 1C33 48                    pha   
0416 1C34 60                    rts   
0417 1C35 C9 07 00     z1s2     cmp   #$7
0418 1C38 90 09                 bcc   z1s3                     ;a < 7, i.e., add, sub, mul, div, cmp, cpx, rem
0419 1C3A C9 0F 00              cmp   #$0f                     ;NextAfter
0420 1C3D D0 72                 bne   notASMD
0421 1C3F A6 2E                 ldx   fence
0422 1C41 86 30                 stx   fence2                   ;NextAfter, destination gets format of source
0423 1C43 86 32        z1s3     stx   fenceSv
0424 1C45 A6 30                 ldx   fence2
0425 1C47 86 2E                 stx   fence
0426 1C49 20 DA 20              jsr   UnPck                    ;get second argument (usually extended)
0427 1C4C A5 10 85 0C           moveA Brgstr,Crgstr
0428 1C54 20 9C 20              jsr   BtoA
0429 1C57 A6 32                 ldx   fenceSv                  ;restore fence
0430 1C59 86 2E                 stx   fence
0431 1C5B              ;      ;ldx     fence
0432 1C5B BC 81 1B              ldy   StkBtWd,x                ;; tmpZP2 := max (lgthA, MaxShft,x)
0433 1C5E C4 42                 cpy   lgthA                    ;StkBtWd,x - lgthC
0434 1C60 10 02                 bpl   z1s4
0435 1C62 A4 42                 ldy   lgthA
0436 1C64 84 34        z1s4     sty   SBWord                   ;maximum length, i.e., max (lgthA, MaxShft,x)
0437 1C66 20 DA 20              jsr   UnPck                    ;get first argument
0438 1C69 A5 3C                 lda   signA
0439 1C6B 45 46                 eor   signB
0440 1C6D 85 50                 sta   signC
0441 1C6F A5 30                 lda   fence2
0442 1C71 85 2E                 sta   fence
0443 1C73 A9 FD FF              lda   #NanTag
0444 1C76 C5 3A                 cmp   Atag                     ;NanTag - Atag
0445 1C78 10 06                 bpl   z1s5                     ;Nan found
0446 1C7A C5 44                 cmp   Btag
0447 1C7C 30 2F                 bmi   z1s9                     ;neither value is a Nan
0448 1C7E 10 1B                 bpl   z1s7                     ;only B is Nan
0449 1C80 C5 44        z1s5     cmp   Btag                     ;NanTag - Btag
0450 1C82 30 06                 bmi   z1s6                     ;only A is a Nan
0451 1C84 A5 58                 lda   FrctA
0452 1C86 C5 72                 cmp   FrctB                    ;FrctA - FrctB
0453 1C88 90 11                 bcc   z1s7                     ;FrctA < FrctB
0454 1C8A 20 7D 20     z1s6     jsr   AtoC
0455 1C8D 38                    sec   
0456 1C8E B0 0E                 bcs   z1s8                     ;branch always !!!!!!!!!
0457 1C90 20 4D 1F     z1s11    jsr   SetInv
0458 1C93 A2 01 01     z1s12    ldx   #$0101                   ;return value for unordered
0459 1C96 86 20                 stx   pendingX
0460 1C98 4C 2D 20              jmp   TrpHd1
0461 1C9B 20 BB 20     z1s7     jsr   BtoC
0462 1C9E A5 36        z1s8     lda   opcode
0463 1CA0 C9 08 00              cmp   #$8
0464 1CA3 F0 EE                 beq   z1s12                    ;cmp
0465 1CA5 C9 0A 00              cmp   #$0a
0466 1CA8 F0 E6                 beq   z1s11                    ;cpx
0467 1CAA 4C 2A 20              jmp   rtnArth
0468 1CAD AD D8 1C     z1s9     lda   rtnA
0469 1CB0 48                    pha   
0470 1CB1 A4 36        notASMD  ldy   opcode
0471 1CB3 B9 B8 1C              lda   table1,y
0472 1CB6 48                    pha   
0473 1CB7 60                    rts   
0474 1CB8                       EXPORT table1 
0475 1CB8 DC 24 D1 24  table1   DC W:add-1,sub-1,mul-1,Xdiv-1,cmpar-1,cmpar-1,rem-1,z2x-1
0476 1CC8 9C 1D B7 1D           DC W:x2z-1,sqr-1,rndti-1,tti-1,scalb-1,logb-1,class-1,next-1
0477 1CD8                       EXPORT rtnA 
0478 1CD8              rtnA                                    ;       
0479 1CD8 29 20                 DC W:rtnArth-1
0480 1CDA                       EXPORT rtnB 
0481 1CDA              rtnB                                    ;       
0482 1CDA 5A 20                 DC W:XitFP-1
0483 1CDC                       EXPORT table2 
0484 1CDC 54 1F 5A 1F  table2   DC W:setE-1,getE-1,setTV-1,getTV-1,D2B-1,B2D-1,neg-1,abs-1
0485 1CEC C8 1F 00 00           DC W:cpySgn-1,0,SetX-1,ProcIn-1,ProcX-1,testX-1
0486 1CF8 68           cmpar    pla                            ;unload rtnA, B rel A
0487 1CF9 AD DA 1C              lda   rtnB
0488 1CFC 48                    pha   
0489 1CFD A5 3A        cmpar2   lda   Atag
0490 1CFF 30 05                 bmi   z2s2
0491 1D01 A9 FF FF              lda   #-1
0492 1D04 80 05                 bra   z2s3                     ;branch always   !!!!!!
0493 1D06 AA           z2s2     tax   
0494 1D07 E8                    inx   
0495 1D08 30 01                 bmi   z2s3
0496 1D0A 8A                    txa   
0497 1D0B A6 3C        z2s3     ldx   signA
0498 1D0D D0 04                 bne   z2s4
0499 1D0F 49 FF FF              eor   #-1                      ;negate 'A'
0500 1D12 1A                    inc   a
0501 1D13 85 24        z2s4     sta   tmpZP
0502 1D15 A5 44                 lda   Btag
0503 1D17 30 05                 bmi   z2s5
0504 1D19 A9 FF FF              lda   #-1
0505 1D1C 80 05                 bra   z2s6                     ;branch always   !!!!!!
0506 1D1E AA           z2s5     tax   
0507 1D1F E8                    inx   
0508 1D20 30 01                 bmi   z2s6
0509 1D22 8A                    txa   
0510 1D23 A6 46        z2s6     ldx   signB
0511 1D25 D0 04                 bne   z2s7
0512 1D27 49 FF FF              eor   #-1                      ;negate 'A'
0513 1D2A 1A                    inc   a
0514 1D2B C5 24        z2s7     cmp   tmpZP                    ; B - A
0515 1D2D 30 50                 bmi   z2s15                    ; B < A
0516 1D2F D0 57                 bne   z2s17                    ; B > A
0517 1D31 4A                    lsr   a
0518 1D32 90 42                 bcc   z2s13                    ; B = A
0519 1D34 38                    sec   
0520 1D35 A5 48                 lda   expnB
0521 1D37 E5 3E                 sbc   expnA
0522 1D39 A8                    tay   
0523 1D3A A5 4A                 lda   expnB+2
0524 1D3C E5 40                 sbc   expnA+2
0525 1D3E 30 3B                 bmi   z2s14                    ; expnB < expnA
0526 1D40 D0 42                 bne   z2s16                    ; expnB > expnA
0527 1D42 98                    tya   
0528 1D43 D0 3F                 bne   z2s16                    ; expnB > expnA
0529 1D45              ;                                       ; expnB = expnA
0530 1D45 A6 4C                 ldx   lgthB
0531 1D47 E4 42                 cpx   lgthA                    ; lgthB - lgthA
0532 1D49 10 12                 bpl   z2s10
0533 1D4B A6 42                 ldx   LgthA                    ; y := max (lgthB, lgthA)
0534 1D4D 74 72        z2s8     stz   FrctB,X
0535 1D4F CA                    dex   
0536 1D50 CA                    dex   
0537 1D51 E4 4C                 cpx   lgthB                    ; x - lgthB
0538 1D53 D0 F8                 bne   z2s8
0539 1D55 A6 42                 ldx   lgthA
0540 1D57 10 0A                 bpl   z2s11
0541 1D59 74 58        z2s9     stz   FrctA,X
0542 1D5B CA                    dex   
0543 1D5C CA                    dex   
0544 1D5D E4 42        z2s10    cpx   lgthA                    ; x - lgthA
0545 1D5F D0 F8                 bne   z2s9
0546 1D61 A6 4C                 ldx   lgthB
0547 1D63 86 24        z2s11    stx   tmpZP
0548 1D65 A2 FE FF              ldx   #-2
0549 1D68 E8           z2s12    inx   
0550 1D69 E8                    inx   
0551 1D6A B5 72                 lda   FrctB,x
0552 1D6C D5 58                 cmp   FrctA,x                  ; FrctB - FrctA
0553 1D6E 90 0B                 bcc   z2s14                    ; FrctB < FrctA
0554 1D70 D0 12                 bne   z2s16                    ; FrctB > FrctA
0555 1D72 E4 24                 cpx   tmpZP                    ; x - tmpZP
0556 1D74 30 F2                 bmi   z2s12
0557 1D76 A2 02 00     z2s13    ldx   #$0002                   ; B = A
0558 1D79 80 10                 bra   endCmp
0559 1D7B A5 46        z2s14    lda   signB
0560 1D7D D0 09                 bne   z2s17                    ;both signs negative
0561 1D7F A2 80 80     z2s15    ldx   #$8080                   ; B < A
0562 1D82 80 07                 bra   endCmp
0563 1D84 A5 46        z2s16    lda   signB
0564 1D86 D0 F7                 bne   z2s15                    ;both signs negative
0565 1D88 A2 40 40     z2s17    ldx   #$4040                   ; B > A
0566 1D8B 86 20        endCmp   stx   pendingX
0567 1D8D 60                    rts   
0568 1D8E 68 85 0C 68  z2x      pop   crgstr                   ;get second argument (usually extended)
0569 1D94 20 DA 20              jsr   UnPck                    ;get first argument
0570 1D97 A5 30                 lda   fence2
0571 1D99 85 2E                 sta   fence                    ;restore fence to ext. (usually) destination
0572 1D9B 80 15                 bra   packit
0573 1D9D 68 85 0C 68  x2z      pop   crgstr                   ;get second argument
0574 1DA3 A5 2E                 lda   fence                    ;save fence
0575 1DA5 85 32                 sta   fenceSv
0576 1DA7 A5 30                 lda   fence2
0577 1DA9 85 2E                 sta   fence                    ;set fence to extended source
0578 1DAB 20 DA 20              jsr   UnPck                    ;get first argument (usually extended)
0579 1DAE A5 32                 lda   fenceSv                  ;restore fence
0580 1DB0 85 2E                 sta   fence
0581 1DB2 20 BB 20     packit   jsr   BtoC
0582 1DB5 4C 2A 20              jmp   rtnArth
0583 1DB8 A5 2E        sqr      lda   fence
0584 1DBA 85 30                 sta   fence2
0585 1DBC 20 DA 20              jsr   UnPck
0586 1DBF A5 10 85 0C           moveA Brgstr,Crgstr
0587 1DC7 20 64 28              jsr   sqrt
0588 1DCA 4C 2A 20              jmp   rtnArth
0589 1DCD 20 DA 20     scalb    jsr   UnPck
0590 1DD0 A5 10 85 14           moveA Brgstr,Argstr
0591 1DD8 A5 10 85 0C           moveA Brgstr,Crgstr
0592 1DE0 20 9C 20              jsr   BtoA
0593 1DE3 18                    clc   
0594 1DE4 68                    pla                            ;get scale factor
0595 1DE5 AA                    tax                            ;save sign of scale integer
0596 1DE6 65 48                 adc   expnB                    ;adjust exponent
0597 1DE8 85 48                 sta   expnB
0598 1DEA 8A                    txa   
0599 1DEB 30 04                 bmi   z3s7
0600 1DED A5 38                 lda   ZeroWord
0601 1DEF F0 03                 beq   z3s8                     ;branch always !!!
0602 1DF1 A9 FF FF     z3s7     lda   #-1
0603 1DF4 65 4A        z3s8     adc   expnB+2
0604 1DF6 85 4A                 sta   expnB+2
0605 1DF8 80 B8                 bra   packit
0606 1DFA 20 DA 20     rndti    jsr   UnPck
0607 1DFD A5 10 85 0C           moveA Brgstr,Crgstr
0608 1E05 20 BB 20              jsr   BtoC
0609 1E08 A5 4E                 lda   Ctag
0610 1E0A 30 03                 bmi   z4s1
0611 1E0C 20 87 2D              jsr   Rnd2Int
0612 1E0F 4C 2A 20     z4s1     jmp   rtnArth
0613 1E12 20 DA 20     tti      jsr   UnPck
0614 1E15 A5 10 85 0C           moveA Brgstr,Crgstr
0615 1E1D 20 BB 20              jsr   BtoC
0616 1E20 A5 4E                 lda   Ctag
0617 1E22 30 1C                 bmi   z5s1
0618 1E24 A5 1C                 lda   envWrd
0619 1E26 85 34                 sta   SBWord                   ;save rounding direction
0620 1E28 09 00 C0              ora   #$0c000                  ;set round towards zero
0621 1E2B 85 1C                 sta   envWrd
0622 1E2D 20 87 2D              jsr   Rnd2Int
0623 1E30 A5 34                 lda   SBWord
0624 1E32 29 00 C0              and   #$0c000
0625 1E35 85 34                 sta   SBWord                   ;get original rounding mode
0626 1E37 A5 1C                 lda   envWrd
0627 1E39 29 FF 3F              and   #$03fff
0628 1E3C 05 34                 ora   SBWord                   ;restore it
0629 1E3E 85 1C                 sta   envWrd
0630 1E40 4C 2A 20     z5s1     jmp   rtnArth
0631 1E43 A5 2E        logb     lda   fence
0632 1E45 85 30                 sta   fence2
0633 1E47 20 DA 20              jsr   UnPck
0634 1E4A A5 10 85 0C           moveA Brgstr,Crgstr
0635 1E52 AD D8 1C              lda   rtnA
0636 1E55 48                    pha   
0637 1E56 A5 44                 lda   Btag
0638 1E58 30 3B                 bmi   z6s4
0639 1E5A A9 02 00              lda   #$2
0640 1E5D 85 56                 sta   lgthC
0641 1E5F 38                    sec   
0642 1E60 A5 48                 lda   expnB
0643 1E62 E9 FF 3F              sbc   #$3fff
0644 1E65 85 8E                 sta   FrctC+2
0645 1E67 A5 4A                 lda   expnB+2
0646 1E69 E5 38                 sbc   zeroWord
0647 1E6B 85 8C                 sta   FrctC
0648 1E6D 10 0F                 bpl   z6s2
0649 1E6F 38                    sec   
0650 1E70 A5 38                 lda   ZeroWord
0651 1E72 E5 8E                 sbc   FrctC+2
0652 1E74 85 8E                 sta   FrctC+2
0653 1E76 A5 38                 lda   ZeroWord
0654 1E78 E5 8C                 sbc   FrctC
0655 1E7A 85 8C                 sta   FrctC
0656 1E7C E6 50                 inc   signC
0657 1E7E 64 54        z6s2     stz   expnC+2
0658 1E80 A9 1E 40              lda   #$401e                   ;3fff + 31.
0659 1E83 85 52                 sta   expnC
0660 1E85 20 00 26              jsr   NrmlzC
0661 1E88 A5 4E                 lda   Ctag
0662 1E8A 10 08                 bpl   z6s3
0663 1E8C 24 1C                 bit   EnvWrd
0664 1E8E 10 04                 bpl   z6s3                     ;either round to nearest or upward
0665 1E90 70 02                 bvs   z6s3                     ;round toward zero
0666 1E92 E6 50                 inc   signC                    ;round downward with a zero result, rtn -0
0667 1E94 60           z6s3     rts   
0668 1E95 1A           z6s4     inc   a
0669 1E96 D0 0B                 bne   z6s6                     ;not zero
0670 1E98 A9 08 00              lda   #dvzXcp
0671 1E9B 20 50 1F              jsr   setXcpn
0672 1E9E E6 50                 inc   signC                    ;return negative infinity
0673 1EA0 4C 36 1F     z6s5     jmp   rtnInf                   ;jsr, rts
0674 1EA3 1A           z6s6     inc   a
0675 1EA4 F0 FA                 beq   z6s5                     ;infinity found
0676 1EA6 4C BB 20              jmp   BtoC                     ;NaN found return input argument
0677 1EA9 20 DA 20     class    jsr   UnPck
0678 1EAC A5 44                 lda   Btag
0679 1EAE 29 FF 00              and   #$0ff                    ;clear high byte
0680 1EB1 0A                    asl   a
0681 1EB2 46 46                 lsr   signB
0682 1EB4 6A                    ror   a                        ;put sign in high bit of word
0683 1EB5 85 20                 sta   pendingX
0684 1EB7 4C 5B 20              jmp   XitFP
0685 1EBA 20 FD 1C     next     jsr   cmpar2
0686 1EBD 8A                    txa   
0687 1EBE 29 00 C0              and   #$0c000                  ;greater or less than
0688 1EC1 D0 03                 bne   BgNext
0689 1EC3 4C 7D 20              jmp   AtoC                     ;jsr, rts
0690 1EC6 64 46        BgNext   stz   signB
0691 1EC8 85 24                 sta   tmpZP
0692 1ECA 10 02                 bpl   z7s1
0693 1ECC E6 46                 inc   signB                    ;negate B
0694 1ECE 45 3C        z7s1     eor   signA
0695 1ED0 85 50                 sta   signC                    ;initialize C for Add
0696 1ED2 A5 1C                 lda   envWrd
0697 1ED4 48                    pha                            ;save rounding direction
0698 1ED5 29 FF 3F              and   #$3fff                   ;clear rounding direction
0699 1ED8 05 24                 ora   tmpZP
0700 1EDA 85 1C                 sta   envWrd
0701 1EDC 64 44                 stz   Btag                     ;put extremely small number in B
0702 1EDE 64 48                 stz   expnB
0703 1EE0 A9 00 F0              lda   #$0f000
0704 1EE3 85 4A                 sta   expnB+2
0705 1EE5 64 4C                 stz   lgthB
0706 1EE7 A9 00 80              lda   #$8000
0707 1EEA 85 72                 sta   FrctB
0708 1EEC A5 3A                 lda   Atag
0709 1EEE C9 FE FF              cmp   #InfTag
0710 1EF1 D0 10                 bne   z7s2
0711 1EF3 64 3A                 stz   Atag                     ;put extremely large number in A
0712 1EF5 64 3E                 stz   expnA
0713 1EF7 A9 FF 0F              lda   #$0fff
0714 1EFA 85 40                 sta   expnA+2
0715 1EFC 64 42                 stz   lgthA
0716 1EFE A9 00 80              lda   #$8000
0717 1F01 85 58                 sta   FrctA
0718 1F03 20 DD 24     z7s2     jsr   Add
0719 1F06 20 F7 22              jsr   ck4URO
0720 1F09              ;       ;;;;;;;;;;;;
0721 1F09 68                    pla   
0722 1F0A 29 00 C0              and   #$0c000
0723 1F0D 85 34                 sta   SBWord                   ;get original rounding mode
0724 1F0F A5 1C                 lda   envWrd
0725 1F11 29 FF 3F              and   #$03fff
0726 1F14 05 34                 ora   SBWord                   ;restore it
0727 1F16 85 1C                 sta   envWrd
0728 1F18 A5 1E                 lda   tmpFlgs
0729 1F1A 29 06 00              and   #$6                      ;underflow and overflow
0730 1F1D F0 0F                 beq   z7s5
0731 1F1F 29 02 00              and   #$2                      ;underflow
0732 1F22 D0 06                 bne   z7s3                     ;underflow execption set
0733 1F24 A5 4E                 lda   Ctag
0734 1F26 30 08                 bmi   z7s7                     ;infinity delivered, save flags
0735 1F28 10 04                 bpl   z7s5
0736 1F2A A5 8C        z7s3     lda   FrctC
0737 1F2C 10 02                 bpl   z7s7                     ;denormal number delivered, save flags
0738 1F2E 64 1E        z7s5     stz   tmpFlgs
0739 1F30 60           z7s7     rts   
0740 1F31                       EXPORT rtnZero 
0741 1F31              rtnZero                                 ;       
0742 1F31 A9 FF FF              lda   #ZeroTag
0743 1F34 D0 03                 bne   rtnInf2
0744 1F36                       EXPORT rtnInf 
0745 1F36              rtnInf                                  ;       
0746 1F36 A9 FE FF              lda   #InfTag
0747 1F39 85 4E        rtnInf2  sta   ctag
0748 1F3B A9 FE FF              lda   #-2
0749 1F3E 85 56                 sta   lgthC
0750 1F40 60                    rts   
0751 1F41                       EXPORT InvNan 
0752 1F41              InvNan                                  ;       
0753 1F41 64 56                 stz   lgthC
0754 1F43                       EXPORT InvNan2 
0755 1F43              InvNan2                                 ;       
0756 1F43 09 00 40              ora   #$4000                   ;mask in 'non signaling bit'
0757 1F46 85 8C                 sta   FrctC
0758 1F48 A9 FD FF              lda   #NanTag
0759 1F4B 85 4E                 sta   Ctag
0760 1F4D                       EXPORT SetInvld 
0761 1F4D              SetInvld                                ;       ;klh <26Feb87> new entry
0762 1F4D A9 01 00     SetInv   lda   #invxcp
0763 1F50                       EXPORT setXcpn 
0764 1F50              setXcpn                                 ;       
0765 1F50 05 1E                 ora   tmpFlgs
0766 1F52 85 1E                 sta   tmpFlgs
0767 1F54 60                    rts   
0768 1F55 68           SetE     pla   
0769 1F56 85 1C                 sta   EnvWrd
0770 1F58 4C 5B 20              jmp   XitFP
0771 1F5B A6 1C        GetE     ldx   EnvWrd                   ;!!! Note entire EnvWrd goes to x !!!
0772 1F5D 86 20                 stx   pendingX
0773 1F5F 4C 5B 20              jmp   XitFP
0774 1F62 68 85 18 68  setTV    pop   HaltVect
0775 1F68 4C 5B 20              jmp   XitFP
0776 1F6B A6 18        getTV    ldx   HaltVect
0777 1F6D 86 20                 stx   pendingX
0778 1F6F A4 1A                 ldy   HaltVect+2
0779 1F71 84 22                 sty   pendingY
0780 1F73 4C 5B 20              jmp   XitFP
0781 1F76 68 85 10 68  neg      pop   Brgstr
0782 1F7C BC 61 1B              ldy   lastW,x                  ;get word with sign bit
0783 1F7F E0 06 00              cpx   #$6
0784 1F82 B0 0A                 bcs   z8s3                     ;not an extended, double, or single
0785 1F84 B7 10        z8s2     lda   [Brgstr],y
0786 1F86 49 00 80              eor   #$8000                   ;change sign bit
0787 1F89 97 10                 sta   [Brgstr],y
0788 1F8B 4C 5B 20              jmp   XitFP
0789 1F8E E0 0C 00     z8s3     cpx   #$0c
0790 1F91 B0 F1                 bcs   z8s2                     ;not a long, integer, or comp type
0791 1F93 BB           NgIntgr  tyx   
0792 1F94 A4 38                 ldy   ZeroWord
0793 1F96 38                    sec   
0794 1F97 A5 38        z9s1     lda   ZeroWord
0795 1F99 F7 10                 sbc   [Brgstr],y
0796 1F9B 97 10                 sta   [Brgstr],y
0797 1F9D C8                    iny   
0798 1F9E CA                    dex   
0799 1F9F C8                    iny   
0800 1FA0 CA                    dex   
0801 1FA1 10 F4                 bpl   z9s1
0802 1FA3 4C 5B 20              jmp   XitFP
0803 1FA6 68 85 10 68  abs      pop   Brgstr
0804 1FAC BC 61 1B              ldy   lastW,x                  ;get word with sign bit
0805 1FAF B7 10                 lda   [Brgstr],y
0806 1FB1 E0 06 00              cpx   #$6
0807 1FB4 B0 08                 bcs   z10s3                    ;extended, double, or single
0808 1FB6 29 FF 7F     z10s2    and   #$7fff                   ;mask out sign bit
0809 1FB9 97 10                 sta   [Brgstr],y
0810 1FBB 4C 5B 20              jmp   XitFP
0811 1FBE E0 0C 00     z10s3    cpx   #$0c
0812 1FC1 B0 F3                 bcs   z10s2                    ;not a long, integer, or comp type
0813 1FC3 0A                    asl   a
0814 1FC4 B0 CD                 bcs   NgIntgr
0815 1FC6 4C 5B 20              jmp   XitFP
0816 1FC9 68 85 0C 68  cpySgn   pop   Crgstr
0817 1FCF 68 85 10 68           pop   Brgstr
0818 1FD5 BC 61 1B              ldy   lastW,x                  ;get word (source) with sign bit
0819 1FD8 B7 10                 lda   [Brgstr],y
0820 1FDA A6 30                 ldx   fence2                   ;get format of destination
0821 1FDC BC 61 1B              ldy   lastW,x                  ;get word (destination) with sign bit
0822 1FDF E0 06 00              cpx   #$6
0823 1FE2 B0 0C                 bcs   z11s3                    ;extended, double, or single (destination)
0824 1FE4 0A           z11s2    asl   a                        ;get sign bit of source into carry
0825 1FE5 08                    php                            ;save status (i.e., sign bit in carry)
0826 1FE6 B7 0C                 lda   [Crgstr],y               ;get sign word of destination
0827 1FE8 0A                    asl   a                        ;clear sign
0828 1FE9 28                    plp                            ;restore status (including sign bit in carry)
0829 1FEA 6A                    ror   a                        ;set sign bit of destination
0830 1FEB 97 0C                 sta   [Crgstr],y               ;store updated sign word (destination)
0831 1FED 4C 5B 20              jmp   XitFP
0832 1FF0 E0 0C 00     z11s3    cpx   #$0c
0833 1FF3 B0 EF                 bcs   z11s2                    ;not a long, integer, or comp (destination)
0834 1FF5 57 10                 eor   [Brgstr],y
0835 1FF7 29 00 80              and   #$8000
0836 1FFA D0 97                 bne   NgIntgr                  ;signs different reverse sign of destination
0837 1FFC 4C 5B 20              jmp   XitFP
0838 1FFF 68           SetX     pla   
0839 2000 D0 2D                 bne   TH2
0840 2002 4C 5B 20              jmp   XitFP
0841 2005 68           TestX    pla   
0842 2006 EB                    xba   
0843 2007 25 1C                 and   EnvWrd
0844 2009 85 20                 sta   pendingX
0845 200B 4C 5B 20              jmp   XitFP
0846 200E 68 85 14 68  ProcIn   pop   argstr
0847 2014 A4 38                 ldy   ZeroWord
0848 2016 A5 1C                 lda   EnvWrd
0849 2018 97 14                 sta   [argstr],y               ;save current state
0850 201A 64 1C                 stz   EnvWrd                   ;set default state
0851 201C 4C 5B 20              jmp   XitFP
0852 201F A5 1C        ProcX    lda   EnvWrd                   ;get current exceptions
0853 2021 EB                    xba                            ;swap bytes
0854 2022 85 1E                 sta   tmpflgs                  ;let trap handler mask in exceptions
0855 2024 68                    pla                            ;get old environment
0856 2025 85 1C                 sta   EnvWrd
0857 2027 4C 2D 20              jmp   TrpHd1
0858 202A 20 27 22     rtnArth  jsr   pck
0859 202D                       EXPORT TrpHd1 
0860 202D              TrpHd1                                  ;       
0861 202D A5 1E                 lda   tmpflgs
0862 202F 29 1F 00     TH2      and   #$1F
0863 2032 24 1C                 bit   EnvWrd
0864 2034 F0 20                 beq   z12s7
0865 2036 A4 18                 ldy   HaltVect
0866 2038 D0 13                 bne   HaltMech
0867 203A A4 1A                 ldy   HaltVect+2
0868 203C F0 18                 beq   z12s7
0869 203E 80 0D                 bra   HaltMech
0870 2040
0871 2040 A4 19        setHV    ldy   HaltVect+1               ; get 3-byte Halt Vector address - 1
0872 2042 A5 18                 lda   HaltVect                 ; onto stack, then RTL
0873 2044 D0 01                 bne   noCryHV                  ; dec HaltVector does not change hi word
0874 2046 88                    dey   
0875 2047 3A           noCryHv  dec   a
0876 2048 5A                    phy                            ; push 2 hi order bytes
0877 2049 8B                    phb                            ;dummy push opf DBR to decrement S by 1
0878 204A 83 01                 sta   1,s                      ; store 2 low order bytes on stack
0879 204C 6B                    rtl                            ; note jsr (below) put correct return
0880 204D              *		; on stack
0881 204D
0882 204D 22 40 20 FC  HaltMech jsl   setHV                    ; store return address for
0883 2051              *		; effective jsl to HaltVect-1
0884 2051 A5 1E                 lda   tmpflgs                  ; <klh 8Aug86>
0885 2053 29 1F 00              and   #$1F                     ; <klh 8Aug86>
0886 2056 EB           z12s7    xba   
0887 2057 05 1C                 ora   EnvWrd
0888 2059 85 1C                 sta   EnvWrd
0889 205B                       EXPORT XitFP 
0890 205B              XitFP                                   ;       
0891 205B 24 20                 bit   pendingX
0892 205D A5 20                 lda   pendingX
0893 205F A4 21                 ldy   pendingX+1
0894 2061 AA                    tax   
0895 2062 29 00 FF              and   #$ff00
0896 2065 D4 04                 pei   ZPRtn+4
0897 2067 D4 02                 pei   ZPRtn+2
0898 2069 D4 00                 pei   ZPRtn
0899 206B 08                    php   
0900 206C A5 08                 lda   OrigBank                 ; restore original data bank
0901 206E 48                    pha   
0902 206F AB                    plb   
0903 2070 AB                    plb   
0904 2071 A5 06                 lda   OrigDirect               ; restore orig direct
0905 2073 5B                    tcd   
0906 2074 A5 38                 lda   ZeroWord                 ; <klh 8Aug86>
0907 2076 28                    plp   
0908 2077 18                    clc   
0909 2078 22 68 00 E1           jsl   DecBusyFlg
0910 207C 6B                    rtl   
0911 207D              ;-
0912 207D              ;+
0913 207D A5 3A 85 4E           RtoR A,C
0914 209C A5 44 85 3A           RtoR B,A
0915 20BB A5 44 85 4E           RtoR B,C
0916 20DA                       ENDP 
0917 20DA              ;          copy sane/unpack
0918 20DA              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0919 20DA              ;; File:  Unpack
0920 20DA              ;; Description: Unpack and Pack for ORCA SANE 65816 floating point engine
0921 20DA              ;; Status: Release 2.0
0922 20DA              ;;
0923 20DA              ;; Written by Kenton Hanson, Apple Numerics Group, 21 May 1986
0924 20DA              ;;
0925 20DA              ;; Modification History:  
0926 20DA              ;;
0927 20DA              ;; 26Feb87          klh 
0928 20DA              ;;
0929 20DA              ;; Sets Invalid on integer overflow
0930 20DA              ;;
0931 20DA              ;; 12 Dec 88        Kenton Hanson
0932 20DA              ;;
0933 20DA              ;; Fixed bug of conversion of large comps to extended.
0934 20DA              ;; Floating point nan conversion to comp nan no longer signals invalid.
0935 20DA              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
0936 20DA                       EXPORT UnPck 
0937 20DA              UnPck    PROC 
0938 20DA FA                    plx                            ;save return from UnPck
0939 20DB 68 85 10 68           pop   Brgstr
0940 20E1 DA                    phx                            ;restore return from UnPck
0941 20E2 64 44                 stz   btag                     ;initialize tag for normal nonzero number
0942 20E4 64 46                 stz   signB                    ;initialize sign to '+'
0943 20E6 64 4A                 stz   expnB+2                  ;initialize high word of exponent to zero
0944 20E8 A6 2E                 ldx   fence
0945 20EA BC 61 1B              ldy   lastW,x
0946 20ED E0 06 00              cpx   #ffLng
0947 20F0 90 70                 bcc   fpUnPck                  ; y < ffLng, i.e., Extended Double or Single
0948 20F2 E0 0C 00              cpx   #ffq
0949 20F5 B0 6B                 bcs   fpUnPck                  ; y >= ffq
0950 20F7              ;fxdUnPck
0951 20F7 64 74                 stz   FrctB+2
0952 20F9 64 76                 stz   FrctB+4
0953 20FB 64 78                 stz   FrctB+6
0954 20FD 64 7A                 stz   FrctB+8                  ; added by Kenton 12 Dec 88
0955 20FF B7 10                 lda   [BRgstr],y
0956 2101 10 29                 bpl   PosFxd
0957 2103 BB                    tyx   
0958 2104 A4 46                 ldy   signB                    ;ldy    #00
0959 2106 E6 46                 inc   signB                    ;set signB to 1 => '-'
0960 2108 38                    sec   
0961 2109 A5 44        z1s1     lda   btag                     ;lda    #00
0962 210B F7 10                 sbc   [BRgstr],y
0963 210D 95 72                 sta   FrctB,x
0964 210F C8                    iny   
0965 2110 CA                    dex   
0966 2111 C8                    iny   
0967 2112 CA                    dex   
0968 2113 10 F4                 bpl   z1s1
0969 2115 AA                    tax   
0970 2116 10 21                 bpl   NrmlWrd
0971 2118 A5 2E                 lda   fence
0972 211A C9 0A 00              cmp   #ffComp
0973 211D D0 1A                 bne   NrmlWrd                  ;not a comp NaN
0974 211F 64 4C                 stz   lgthB
0975 2121 A9 14 40              lda   #NaNComp
0976 2124 85 72                 sta   FrctB
0977 2126 A9 FD FF              lda   #NanTag
0978 2129 85 44                 sta   btag
0979 212B 60                    rts   
0980 212C BB           PosFxd   tyx   
0981 212D A4 46                 ldy   signB                    ;ldy    #00
0982 212F B7 10        z2s1     lda   [BRgstr],y
0983 2131 95 72                 sta   FrctB,x
0984 2133 C8                    iny   
0985 2134 CA                    dex   
0986 2135 C8                    iny   
0987 2136 CA                    dex   
0988 2137 10 F6                 bpl   z2s1
0989 2139 A5 72        NrmlWrd  lda   FrctB
0990 213B D0 17                 bne   z3s1
0991 213D A5 74                 lda   FrctB+2
0992 213F 85 72                 sta   FrctB
0993 2141 A5 76                 lda   FrctB+4
0994 2143 85 74                 sta   FrctB+2
0995 2145 A5 78                 lda   FrctB+6
0996 2147 85 76                 sta   FrctB+4
0997 2149 64 78                 stz   FrctB+6                  ;clear last word
0998 214B 88                    dey   
0999 214C 88                    dey   
1000 214D D0 EA                 bne   NrmlWrd
1001 214F 64 4C                 stz   lgthB                    ;make sure length is not total garbage
1002 2151 4C D3 21              jmp   ZrTagB
1003 2154 98           z3s1     tya   
1004 2155 85 4C                 sta   lgthB
1005 2157 0A                    asl   a
1006 2158 0A                    asl   a
1007 2159 0A                    asl   a
1008 215A 69 FE 3F              adc   #$3ffe                   ;add correct bias
1009 215D 85 48                 sta   expnB
1010 215F 4C 14 22              jmp   normB
1011 2162 B7 10        fpUnPck  lda   [BRgstr],y
1012 2164 0A                    asl   a
1013 2165 26 46                 rol   signB                    ;set sign word 0 for '+', 1 for '-'
1014 2167 4A                    lsr   a                        ;strip off sign bit
1015 2168 85 48                 sta   expnB                    ;store low word of exponent
1016 216A A2 FE FF              ldx   #-2
1017 216D 86 4C                 stx   lgthB                    ;initialize length of fraction to -2
1018 216F 88                    dey   
1019 2170 88                    dey   
1020 2171 E8           z4s1     inx   
1021 2172 E8                    inx   
1022 2173 B7 10                 lda   [BRgstr],y
1023 2175 F0 02                 beq   z4s2                     ;zero word found don't update length
1024 2177 86 4C                 stx   lgthB                    ;update length
1025 2179 95 72        z4s2     sta   FrctB,x
1026 217B 88                    dey   
1027 217C 88                    dey   
1028 217D 10 F2                 bpl   z4s1
1029 217F A4 2E                 ldy   fence
1030 2181 F0 3D                 beq   z4s9                     ;unpacking an extended
1031 2183 C0 0C 00              cpy   #ffq
1032 2186 B0 38                 bcs   z4s9                     ; y >= ffq
1033 2188 BE 61 1B              ldx   lastW,y                  ;either a double or a single
1034 218B 86 4C                 stx   lgthB                    ;set max length
1035 218D 74 72                 stz   FrctB,X                  ;zero last word
1036 218F BE 8F 1B              ldx   ShftDS-2,y               ;get # of left shifts
1037 2192 46 48        z4s3     lsr   expnB                    ;right shift x bits
1038 2194 66 72                 ror   FrctB
1039 2196 66 74                 ror   FrctB+2
1040 2198 66 76                 ror   FrctB+4
1041 219A 66 78                 ror   FrctB+6
1042 219C CA                    dex   
1043 219D D0 F3                 bne   z4s3
1044 219F A5 48                 lda   expnB
1045 21A1 38                    sec                            ;set implicit bit
1046 21A2 D0 05                 bne   z4s4                     ;normalized number found
1047 21A4 E6 44                 inc   btag                     ;set tag to 1
1048 21A6 E6 48                 inc   expnB                    ;increment exponent
1049 21A8 18                    clc                            ;clear implicit bit
1050 21A9 66 72        z4s4     ror   FrctB
1051 21AB 66 74                 ror   FrctB+2
1052 21AD 66 76                 ror   FrctB+4
1053 21AF 66 78                 ror   FrctB+6
1054 21B1 20 18 22              jsr   TailOff
1055 21B4 A5 48                 lda   expnB
1056 21B6 D9 99 1B              cmp   MaxExp,y
1057 21B9 B0 21                 bcs   NanInf                   ; a >= MaxExp,y
1058 21BB 79 93 1B              adc   ExpAdj-2,y
1059 21BE 85 48                 sta   expnB
1060 21C0 A5 48        z4s9     lda   expnB
1061 21C2 D0 06                 bne   z4s10
1062 21C4 A6 72                 ldx   FrctB
1063 21C6 30 02                 bmi   z4s10                    ;not a denormalized extended
1064 21C8 E6 44                 inc   btag                     ;denormalized number found
1065 21CA C9 FF 7F     z4s10    cmp   #$7fff
1066 21CD F0 0D                 beq   NanInf                   ;maximum exponent (either a NaN or Infinity)
1067 21CF A6 4C                 ldx   lgthB
1068 21D1 10 41                 bpl   normB                    ;not a zero
1069 21D3 A9 FF FF     ZrTagB   lda   #ZeroTag                 ;zero found, set tag (=-1), length to -2 & exit
1070 21D6 85 44                 sta   Btag
1071 21D8 3A                    dec   a
1072 21D9 85 4C                 sta   lgthB
1073 21DB 60                    rts   
1074 21DC              ;       ; handle NaNs and Infinities
1075 21DC A5 72        NaNInf   lda   FrctB
1076 21DE A2 FE FF              ldx   #-2                      ;infinity tag
1077 21E1 A4 4C                 ldy   lgthB
1078 21E3 30 19                 bmi   z5s2                     ;infinity found
1079 21E5 D0 05                 bne   z5s1
1080 21E7 C9 00 80              cmp   #$8000                   ;infinity, if this is the only bit set!
1081 21EA F0 12                 beq   z5s2                     ;only the bit left of decimal is set, i.e. inf.
1082 21EC CA           z5s1     dex                            ;set x to (-3) quiet NaN
1083 21ED 09 00 40              ora   #$4000                   ;mask in non signaling NaN bit
1084 21F0 C5 72                 cmp   FrctB
1085 21F2 F0 0A                 beq   z5s2                     ;quiet NaN
1086 21F4 CA                    dex                            ;signalling NaN (-4)
1087 21F5 85 72                 sta   FrctB                    ;change to quiet NaN
1088 21F7 A5 1E                 lda   tmpflgs                  ;set invalid exception
1089 21F9 09 01 00              ora   #invxcp
1090 21FC 85 1E                 sta   tmpFlgs
1091 21FE 86 44        z5s2     stx   btag
1092 2200 4C 18 22              jmp   TailOff
1093 2203                       EXPORT BgnNrmB 
1094 2203              BgnNrmB                                 ;       
1095 2203 A6 4C                 ldx   lgthB                    ;left shift one bit
1096 2205 18                    clc   
1097 2206 36 72        z6s1     rol   FrctB,x
1098 2208 CA                    dex   
1099 2209 CA                    dex   
1100 220A 10 FA                 bpl   z6s1
1101 220C A5 48                 lda   expnB                    ;increment exponent
1102 220E D0 02                 bne   z6s2
1103 2210 C6 4A                 dec   expnB+2
1104 2212 C6 48        z6s2     dec   expnB
1105 2214 A5 72        normB    lda   FrctB
1106 2216 10 EB                 bpl   BgnNrmB                  ;still not normalized
1107 2218 A6 4C        TailOff  ldx   lgthB
1108 221A 30 0A                 bmi   z7s2
1109 221C B5 72        z7s1     lda   FrctB,x                  ;strip trailing zero words
1110 221E D0 06                 bne   z7s2
1111 2220 CA                    dex   
1112 2221 CA                    dex   
1113 2222 86 4C                 stx   lgthB
1114 2224 10 F6                 bpl   z7s1
1115 2226 60           z7s2     rts                            ;END OF UNPACK   END OF UNPACK   END OF UNPACK
1116 2227                       EXPORT pck 
1117 2227              pck                                     ;       
1118 2227 A6 2E                 ldx   fence
1119 2229 A4 4E                 ldy   ctag
1120 222B 30 31                 bmi   ZIN                      ;either a zero, infinity or NaN
1121 222D 20 F7 22              jsr   ck4URO                   ;check for underflow, round, check for overflow
1122 2230 A6 2E        StuffIt  ldx   fence
1123 2232              ;      ;beq     StuffEx         ;extended
1124 2232 D0 03                 bne   z8s1
1125 2234 4C CB 22              jmp   StuffEx
1126 2237 E0 06 00     z8s1     cpx   #ffLng
1127 223A 90 5D                 bcc   PkDblSg                  ; x < ffLng, i.e., Double or Single
1128 223C E0 0C 00              cpx   #ffq
1129 223F 90 03                 bcc   @skip                    ; Changed 12 Dec 88 to handle long branch
1130 2241 82 87 00              brl   StuffEx                  ; x >= ffq
1131 2244              @skip     
1132 2244              ;   ;integer longInt or comp
1133 2244 BC 61 1B              ldy   lastW,x
1134 2247 A6 50                 ldx   signC                    ; dual purpose, also initializes x to zero
1135 2249 F0 0E                 beq   z8s3                     ;LgInCmp         ; branch to long, integer, Comp
1136 224B BB                    tyx   
1137 224C 38                    sec   
1138 224D A5 38        z8s2     lda   ZeroWord
1139 224F F5 8C                 sbc   FrctC,x
1140 2251 95 8C                 sta   FrctC,x
1141 2253 CA                    dex   
1142 2254 CA                    dex   
1143 2255 10 F6                 bpl   z8s2
1144 2257 A6 38                 ldx   ZeroWord
1145 2259              z8s3      
1146 2259 D0 03                 bne   ZIN                      ; changed 12 Dec 88 to handle long branch
1147 225B 82 86 00              brl   LgInCmp                  ; branch to long, integer, Comp
1148 225E
1149 225E C8           ZIN      iny   
1150 225F D0 12                 bne   LdMxXp                   ;Infinity or NaN Encountered
1151 2261 64 56                 stz   lgthC                    ;zero Encountered
1152 2263 A5 56                 lda   lgthC
1153 2265 C6 56                 dec   lgthC                    ;make sure lgthC is negative
1154 2267 E0 06 00              cpx   #ffLng
1155 226A 90 62                 bcc   stffItZ                  ; x < ffLng, i.e., Extended, Double or Single
1156 226C E0 0C 00              cpx   #ffq
1157 226F 90 60                 bcc   ZeroILC                  ; force positive zero for Long, integer & comp
1158 2271 B0 5B                 bcs   StffItZ                  ; x >= ffq
1159 2273 BD BD 1B     LdMxXp   lda   MaxAdj,x
1160 2276 85 52                 sta   expnC
1161 2278 E0 06 00              cpx   #ffLng
1162 227B 90 B3                 bcc   stuffIt                  ; x < ffLng, i.e., Extended, Double or Single
1163 227D E0 0C 00              cpx   #ffq
1164 2280 B0 AE                 bcs   StuffIt                  ; x >= ffq
1165 2282
1166 2282 E0 0A 00              cpx   #ffComp                  ; added 12 Dec 88
1167 2285 D0 03                 bne   seti88
1168 2287 C8                    iny   
1169 2288 30 03                 bmi   nSet88                   ; end addition
1170 228A
1171 228A 20 4D 1F     seti88   jsr   SetInvld                 ; 26Feb87 klh Sets Invalid on integer overflow
1172 228D BC 61 1B     nSet88   ldy   lastW,x
1173 2290 64 56                 stz   lgthC
1174 2292 A6 56                 ldx   lgthC
1175 2294 A9 00 80              lda   #$8000
1176 2297 D0 4D                 bne   LgInCmp2                 ; branch to long, integer, Comp
1177 2299 BC 8F 1B     PkDblSg  ldy   ShftDS-2,x               ;number of left shifts to align dbl & sgl
1178 229C A6 56                 ldx   lgthC
1179 229E 30 07                 bmi   z9s2
1180 22A0 18                    clc   
1181 22A1 36 8C        z9s1     rol   FrctC,x                  ;shift one bit to set carry
1182 22A3 CA                    dex   
1183 22A4 CA                    dex   
1184 22A5 10 FA                 bpl   z9s1
1185 22A7 A6 4E        z9s2     ldx   Ctag
1186 22A9 E8                    inx   
1187 22AA D0 03                 bne   z9s3                     ;not zero
1188 22AC 8A                    txa                            ;ldaI   0
1189 22AD F0 1F                 beq   stffitz
1190 22AF 10 01        z9s3     bpl   z9s4                     ;not infinity or a Nan
1191 22B1 38                    sec                            ;need to set carry for subtract below
1192 22B2 A6 2E        z9s4     ldx   fence
1193 22B4 A5 52                 lda   expnC
1194 22B6 FD 93 1B              sbc   ExpAdj-2,x               ;carry set depending on implicit bit above (rol)
1195 22B9 85 52                 sta   expnC
1196 22BB 18           z9s5     clc   
1197 22BC A6 56                 ldx   lgthC
1198 22BE 30 06                 bmi   z9s7
1199 22C0 36 8C        z9s6     rol   FrctC,x                  ;finish shifting
1200 22C2 CA                    dex   
1201 22C3 CA                    dex   
1202 22C4 10 FA                 bpl   z9s6
1203 22C6 26 52        z9s7     rol   expnC
1204 22C8 88                    dey   
1205 22C9 D0 F0                 bne   z9s5
1206 22CB A5 52        StuffEx  lda   expnC
1207 22CD 0A                    asl   a
1208 22CE 46 50        stffitz  lsr   signC                    ;shift sign bit into carry
1209 22D0 6A                    ror   a
1210 22D1 A6 2E        ZeroILC  ldx   fence
1211 22D3 BC 61 1B              ldy   lastW,x
1212 22D6 97 0C                 sta   [CRgstr],y               ;store sign & exponent
1213 22D8 A2 FF FF              ldx   #-1
1214 22DB 88                    dey   
1215 22DC 30 0E                 bmi   IntFrmt
1216 22DE E4 56        loop8    cpx   lgthC
1217 22E0 10 0B                 bpl   FillZWd                  ; x >= lgthC
1218 22E2 E8                    inx   
1219 22E3 88                    dey   
1220 22E4 B5 8C        LgInCmp  lda   FrctC,x
1221 22E6 97 0C        LgInCmp2 sta   [CRgstr],y
1222 22E8 E8                    inx   
1223 22E9 88                    dey   
1224 22EA 10 F2                 bpl   loop8
1225 22EC 60           IntFrmt  rts   
1226 22ED A9 00 00     FillZWd  lda   #$0                      ;fill out zero words
1227 22F0 88           z10s10   dey   
1228 22F1 97 0C                 sta   [CRgstr],y
1229 22F3 88                    dey   
1230 22F4 10 FA                 bpl   z10s10
1231 22F6 60                    rts   
1232 22F7                       EXPORT ck4URO 
1233 22F7              ck4URO                                  ;       
1234 22F7 A6 2E                 ldx   fence
1235 22F9 A9 C0 00              lda   #$00c0                   ;mask for Rounding Precision
1236 22FC 25 1C                 and   EnvWrd
1237 22FE F0 0A                 beq   noRP
1238 2300 4A                    lsr   a
1239 2301 4A                    lsr   a
1240 2302 4A                    lsr   a
1241 2303 4A                    lsr   a
1242 2304 4A                    lsr   a
1243 2305 C5 2E                 cmp   fence                    ;a (RP) - fence
1244 2307 90 01                 bcc   noRP                     ;a < fence
1245 2309 AA                    tax   
1246 230A 86 32        noRP     stx   fenceSV                  ;local fence
1247 230C E0 0E 00              cpx   #ffqq
1248 230F F0 20                 beq   RoundIt                  ;no underflow checking
1249 2311 18                    clc   
1250 2312 BD 9F 1B              lda   MinExp,x
1251 2315 E5 52                 sbc   expnC                    ;MinExp,x - expnC - 1
1252 2317 85 BE                 sta   expnX                    ;save low word of subtract
1253 2319 A5 38                 lda   ZeroWord
1254 231B E5 54                 sbc   expnC+2
1255 231D 30 12                 bmi   RoundIt                  ;no underflow, go to rounding code
1256 231F 85 C0                 sta   expnX+2
1257 2321 E6 BE                 inc   expnX
1258 2323 D0 02                 bne   z11s1
1259 2325 E6 C0                 inc   expnX+2
1260 2327 BD 9F 1B     z11s1    lda   MinExp,x                 ;store minimum exponent
1261 232A 85 52                 sta   expnC
1262 232C 64 54                 stz   expnC+2
1263 232E 20 D2 30              jsr   DnrmC
1264 2331 A4 32        RoundIt  ldy   fenceSV
1265 2333 BE 71 1B              ldx   lastSig,y
1266 2336 86 2A                 stx   TmpZP4                   ;save lastSig,y for later update of lgthC
1267 2338 88                    dey   
1268 2339 30 4D                 bmi   z12s5                    ;extended, bypass this double & single stuff
1269 233B 88                    dey   
1270 233C D0 23                 bne   z12s2
1271 233E A9 04 00              lda   #$4
1272 2341 C5 56                 cmp   lgthC
1273 2343 10 47                 bpl   NoRnd                    ;4 >= lgthC
1274 2345 A5 92                 lda   FrctC+6
1275 2347 29 00 08              and   #$800
1276 234A 85 26                 sta   TmpZp2                   ;store lsb in TmpZP2
1277 234C A5 92                 lda   FrctC+6
1278 234E 29 00 04              and   #$400
1279 2351 85 24                 sta   TmpZP                    ;store round bit in TmpZP
1280 2353 A5 92                 lda   FrctC+6
1281 2355 85 28                 sta   TmpZP3
1282 2357 29 00 F8              and   #$0f800
1283 235A 85 92                 sta   FrctC+6                  ;clear bits after lsb
1284 235C A9 FF 03              lda   #$3ff
1285 235F D0 22                 bne   z12s4
1286 2361 88           z12s2    dey   
1287 2362 88                    dey   
1288 2363 D0 23                 bne   z12s5
1289 2365 A5 56                 lda   lgthC
1290 2367 F0 23                 beq   NoRnd
1291 2369 A5 8E                 lda   FrctC+2
1292 236B 29 00 01              and   #$100
1293 236E 85 26                 sta   TmpZp2                   ;store lsb in TmpZP2
1294 2370 A5 8E                 lda   FrctC+2
1295 2372 29 80 00              and   #$80
1296 2375 85 24                 sta   TmpZP                    ;store round bit in TmpZP
1297 2377 A5 8E                 lda   FrctC+2
1298 2379 85 28                 sta   TmpZP3
1299 237B 29 00 FF              and   #$0ff00
1300 237E 85 8E                 sta   FrctC+2                  ;clear bits after lsb
1301 2380 A9 7F 00              lda   #$7f
1302 2383 25 28        z12s4    and   TmpZP3                   ;get sticky bits into A
1303 2385 18                    clc                            ;branch always   branch always   branch always
1304 2386 90 17                 bcc   StkBtLp                  ;branch always   branch always   branch always
1305 2388 E4 56        z12s5    cpx   lgthC                    ;x - lgthC
1306 238A 30 03                 bmi   Rnding                   ;lastSig,y < lgthC
1307 238C 4C 38 24     NoRnd    jmp   OvrflCk
1308 238F B5 8C        Rnding   lda   FrctC,x
1309 2391 29 01 00              and   #$1
1310 2394 85 26                 sta   tmpZP2                   ;store lsb in tmpZP2
1311 2396 64 24                 stz   tmpZP
1312 2398 E8                    inx   
1313 2399 E8                    inx   
1314 239A B5 8C                 lda   FrctC,x
1315 239C 0A                    asl   a                        ;store sticky bit in A
1316 239D 66 24                 ror   tmpZP                    ;store round bit in tmpZP
1317 239F A8           StkBtLp  tay                            ;Sticky Bit Loop, put sticky bits in 'A'
1318 23A0 D0 0A                 bne   z13s7                    ;sticky bit found
1319 23A2 E4 56        z13s6    cpx   lgthC                    ;x - lgthC
1320 23A4 10 06                 bpl   z13s7                    ;y >= lgthC, no more words to examine
1321 23A6 E8                    inx   
1322 23A7 E8                    inx   
1323 23A8 15 8C                 ora   FrctC,x                  ;or sticky bits
1324 23AA F0 F6                 beq   z13s6                    ;no sticky bit, continue looking
1325 23AC 85 28        z13s7    sta   tmpZP3                   ;save sticky bits
1326 23AE A6 2A                 ldx   TmpZp4                   ;get lastSig,y(fenceSV)
1327 23B0 86 56                 stx   lgthC                    ;update length of C
1328 23B2 05 24                 ora   tmpZP                    ;or sticky bit with round bit
1329 23B4 F0 6C                 beq   DumpTrZ                  ;no trailing bits, therefore, no rounding
1330 23B6 A5 1E                 lda   tmpflgs                  ;set inexact exception
1331 23B8 09 10 00              ora   #inexcp
1332 23BB A6 8C                 ldx   FrctC
1333 23BD 30 0F                 bmi   z13s8                    ;normalized number, do not set underflow
1334 23BF A4 32                 ldy   fenceSV
1335 23C1 C0 06 00              cpy   #ffLng
1336 23C4 90 05                 bcc   UnderF                   ;extended, double, or single
1337 23C6 C0 0C 00              cpy   #ffq
1338 23C9 90 03                 bcc   z13s8                    ;long, integer, or Comp
1339 23CB 09 02 00     UnderF   ora   #unfxcp
1340 23CE 85 1E        z13s8    sta   tmpFlgs
1341 23D0 A9 00 C0              lda   #$0c000                  ;mask in rounding direction
1342 23D3 24 1C                 bit   EnvWrd
1343 23D5 F0 10                 beq   RndNr
1344 23D7 30 06                 bmi   z13s9                    ;either downward or toward zero
1345 23D9 A5 50                 lda   signC                    ;round upward
1346 23DB F0 14                 beq   RndUp                    ;sign is positive
1347 23DD D0 43                 bne   DumpTrZ                  ;no rounding up (in magnitude)
1348 23DF 70 41        z13s9    bvs   DumpTrZ                  ;toward zero
1349 23E1 A5 50                 lda   signC                    ;round downward
1350 23E3 D0 0C                 bne   RndUp                    ;sign is negative
1351 23E5 F0 3B                 beq   DumpTrZ                  ;no rounding up (in magnitude)
1352 23E7 A5 24        RndNr    lda   tmpZp                    ;get round bit
1353 23E9 F0 37                 beq   DumpTrZ                  ;no round bit, dump trailing zero words
1354 23EB A5 28                 lda   tmpZP3                   ;get sticky bits
1355 23ED 05 26                 ora   tmpZP2                   ;or lsb & sticky bit
1356 23EF F0 31                 beq   DumpTrZ                  ;no rounding up (in magnitude)
1357 23F1              ;                       environment word is rr-xdoui RR-XDOUI
1358 23F1              ;                                           rd xcpns rp halts
1359 23F1              ;               0 to nearest, 1 upward, 2 downward, 3 toward zero
1360 23F1 A4 32        RndUp    ldy   fenceSV
1361 23F3 BE 71 1B              ldx   LastSig,y
1362 23F6 88                    dey   
1363 23F7 30 18                 bmi   z14s3                    ;extended format, bypass double & single check
1364 23F9 88                    dey   
1365 23FA D0 05                 bne   z14s1                    ;not a double
1366 23FC A9 00 08              lda   #$800
1367 23FF D0 07                 bne   z14s2                    ;branch always
1368 2401 88           z14s1    dey   
1369 2402 88                    dey   
1370 2403 D0 0C                 bne   z14s3                    ;not a single
1371 2405 A9 00 01              lda   #$100
1372 2408 18           z14s2    clc   
1373 2409 75 8C                 adc   FrctC,x
1374 240B 95 8C                 sta   FrctC,x
1375 240D 90 13                 bcc   DumpTrZ
1376 240F B0 04                 bcs   z14s4
1377 2411 F6 8C        z14s3    inc   FrctC,x
1378 2413 D0 0D                 bne   DumpTrZ
1379 2415 CA           z14s4    dex   
1380 2416 CA                    dex   
1381 2417 10 F8                 bpl   z14s3
1382 2419 38                    sec   
1383 241A 66 8C                 ror   FrctC                    ;right shift signicand
1384 241C E6 52                 inc   expnC                    ;adjust the exponent
1385 241E D0 02                 bne   DumpTrZ
1386 2420 E6 54                 inc   expnC+2
1387 2422 A6 56        DumpTrZ  ldx   lgthC                    ;dump trailing Zero words
1388 2424 B5 8C                 lda   FrctC,x
1389 2426 D0 10                 bne   OvrflCk                  ;non zero word found, exit to Overflow check
1390 2428 C6 56                 dec   lgthC
1391 242A C6 56                 dec   lgthC
1392 242C 10 F4                 bpl   DumpTrZ
1393 242E A4 2E                 ldy   fence
1394 2430 B9 9F 1B              lda   MinExp,y
1395 2433 85 52                 sta   expnC
1396 2435 4C 31 1F              jmp   rtnZero
1397 2438 A4 32        OvrflCk  ldy   fenceSV
1398 243A C0 06 00              cpy   #ffLng
1399 243D 90 38                 bcc   OvfEDS                   ; x < ffLng, i.e., Extended, Double or Single
1400 243F C0 0C 00              cpy   #ffq
1401 2442 B0 2E                 bcs   OvfR                     ; x >= ffq
1402 2444 A6 8C                 ldx   FrctC
1403 2446 10 1C                 bpl   RtsOut                   ;no integer overflow, leading bit is off
1404 2448 A5 50                 lda   signC
1405 244A F0 19                 beq   MxNgI                    ;leading bit on, but number is positive
1406 244C A5 54                 lda   expnC+2
1407 244E D0 15                 bne   MxNgI                    ;overflow
1408 2450 A5 52                 lda   expnC
1409 2452 D9 BD 1B              cmp   MaxAdj,y
1410 2455 D0 0B                 bne   z15s1                    ;expnC <> MaxAdj,y
1411 2457 A5 56                 lda   lgthC
1412 2459 D0 0A                 bne   MxNgI                    ;overflow, length greater than one word
1413 245B E0 00 80              cpx   #$8000
1414 245E F0 04                 beq   RtsOut                   ;max negative number
1415 2460 D0 03                 bne   MxNgI
1416 2462 B0 01        z15s1    bcs   MxNgI                    ;expnC > MaxAdj,y
1417 2464 60           RtsOut   rts   
1418 2465 A9 00 80     MxNgI    lda   #$8000                   ;Stuff Maximum Negative Integer
1419 2468 85 8C                 sta   frctC
1420 246A 64 56                 stz   lgthC
1421 246C 20 4D 1F              jsr   SetInvld                 ; 26Feb87 klh Sets Invalid on integer overflow
1422 246F 4C 36 1F              jmp   rtnInf
1423 2472 C0 0E 00     OvfR     cpy   #$0e
1424 2475 F0 ED                 beq   RtsOut
1425 2477 A5 54        OvfEDS   lda   expnC+2
1426 2479 30 E9                 bmi   RtsOut
1427 247B D0 07                 bne   Ovrfld
1428 247D A5 52                 lda   expnC
1429 247F D9 BD 1B              cmp   MaxAdj,y                 ;expnC - MaxAdj,y
1430 2482 90 E0                 bcc   RtsOut                   ;expnC < MaxAdj,y
1431 2484              ;Ovrfld  ;set inexact and overflow
1432 2484 A5 1E        Ovrfld   lda   tmpflgs
1433 2486 09 14 00              ora   #ovfxcp+inexcp
1434 2489 85 1E                 sta   tmpflgs
1435 248B 64 54                 stz   expnC+2                  ;stuff maximum exponent
1436 248D B9 BD 1B              lda   MaxAdj,y
1437 2490 85 52                 sta   expnC
1438 2492 A9 00 C0              lda   #$0c000                  ;mask for rounding direction bits
1439 2495 24 1C                 bit   EnvWrd
1440 2497 F0 08                 beq   OvrInf                   ;Round to nearest, set infinity
1441 2499 50 10                 bvc   RNlbl                    ;Round to negative
1442 249B 30 12                 bmi   MaxVal                   ;Round toward zero, deliver maximum value
1443 249D A5 50                 lda   signC                    ;Round postive
1444 249F D0 0E                 bne   MaxVal                   ;RP and negative value
1445 24A1              ;                                       ;RP and positive value
1446 24A1 A4 2E        OvrInf   ldy   fence
1447 24A3 B9 BD 1B              lda   MaxAdj,y
1448 24A6 85 52                 sta   expnC
1449 24A8 4C 36 1F              jmp   rtnInf                   ;return infinity
1450 24AB A5 50        RNlbl    lda   signC
1451 24AD D0 F2                 bne   OvrInf                   ;RN and negative value
1452 24AF              ;                                       ;RN and positive value
1453 24AF C6 52        MaxVal   dec   expnC                    ;decrement exponent to maximum numeric value
1454 24B1 BE 71 1B              ldx   lastSig,y
1455 24B4 86 56                 stx   lgthC
1456 24B6 A9 FF FF              lda   #-1                      ; FFFF
1457 24B9 95 8C        z16s1    sta   FrctC,x
1458 24BB CA                    dex   
1459 24BC CA                    dex   
1460 24BD 10 FA                 bpl   z16s1
1461 24BF 88                    dey   
1462 24C0 88                    dey   
1463 24C1 D0 05                 bne   z16s2                    ;not a double
1464 24C3 A9 00 F8              lda   #$0f800
1465 24C6 85 92                 sta   FrctC+6
1466 24C8 88           z16s2    dey   
1467 24C9 88                    dey   
1468 24CA D0 98                 bne   RtsOut                   ;not a single
1469 24CC A9 00 FF              lda   #$0ff00
1470 24CF 85 8E                 sta   FrctC+2
1471 24D1 60                    rts   
1472 24D2              ;-
1473 24D2              ;+
1474 24D2                       ENDP 
1475 24D2              ;          copy sane/asmdrs
1476 24D2              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
1477 24D2              ;; File:  ASMDRS
1478 24D2              ;; Description: Add Subtract Multiply, Divide, Remainder
1479 24D2              ;;              and Squareroot, for ORCA SANE 65816 floating point engine
1480 24D2              ;; Status: Alpha
1481 24D2              ;;
1482 24D2              ;; Written by Kenton Hanson, Apple Numerics Group, 20 May 1986
1483 24D2              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
1484 24D2                       EXPORT Sub 
1485 24D2              Sub      PROC 
1486 24D2 A9 01 00              lda   #$1
1487 24D5 45 46                 eor   signB                    ;reverse sign of source
1488 24D7 85 46                 sta   signB
1489 24D9 45 3C                 eor   signA
1490 24DB 85 50                 sta   signC
1491 24DD                       EXPORT Add 
1492 24DD              Add                                     ;       
1493 24DD A6 3A                 ldx   Atag                     ;A - B
1494 24DF 30 09                 bmi   z1s3
1495 24E1 A4 44                 ldy   Btag
1496 24E3 10 27                 bpl   BgnAdSb                  ;no special cases
1497 24E5 C8                    iny   
1498 24E6 F0 10                 beq   z1s6                     ;B is zero and A is a number, return A
1499 24E8 30 08                 bmi   z1s4                     ;B is infinity and A is a number, return B
1500 24EA A4 44        z1s3     ldy   Btag
1501 24EC E8                    inx   
1502 24ED 30 06                 bmi   z1s5                     ;A is infinity
1503 24EF C8                    iny                            ;A is zero
1504 24F0 F0 13                 beq   z1s9                     ;A is zero and B is zero, return a zero
1505 24F2              ;                                       ;A is zero and B is not a zero, return B
1506 24F2 4C BB 20     z1s4     jmp   BtoC                     ;return B
1507 24F5 C8           z1s5     iny   
1508 24F6 30 03                 bmi   z1s7                     ;A is infinity and B is infinity, check signs
1509 24F8              ;                                       ;A is infinity and B is not infinity, return A
1510 24F8 4C 7D 20     z1s6     jmp   AtoC                     ;return A
1511 24FB A5 50        z1s7     lda   signC
1512 24FD F0 F9                 beq   z1s6                     ;signs of infinities are compatible
1513 24FF A9 02 40              lda   #NanAdd
1514 2502 4C 41 1F              jmp   InvNan
1515 2505 A5 50        z1s9     lda   signC
1516 2507 F0 EF                 beq   z1s6                     ;sum of zeros with same sign
1517 2509 4C 24 26              jmp   ZrRslt                   ;0-0 or 0+(-0), ck rounding direction for sign
1518 250C 38           BgnAdSb  sec   
1519 250D A5 3E                 lda   expnA
1520 250F E5 48                 sbc   expnB
1521 2511 85 BE                 sta   expnX
1522 2513 A5 40                 lda   expnA+2
1523 2515 E5 4A                 sbc   expnB+2
1524 2517 85 C0                 sta   expnX+2
1525 2519 30 1F                 bmi   AxltBx                   ;expnA < expnB
1526 251B              ;                                       ;expnA >= expnB
1527 251B A5 44 85 4E           RtoRXpn B,C,A                  ;B to C with sign & exponent of A
1528 2537 4C 80 25              jmp   DMC                      ;Branch always !!!!!!!!!!!!!!!!!!
1529 253A                       EXPORT AxltBx 
1530 253A              AxltBx                                  ; 
1531 253A A5 3A 85 4E           RtoRXpn A,C,B                  ;A to C with sign & exponent of B
1532 2556 A5 3C                 lda   signA
1533 2558 85 46                 sta   signB
1534 255A A6 4C                 ldx   lgthB
1535 255C 86 42                 stx   lgthA
1536 255E B5 72        z2s1     lda   FrctB,x
1537 2560 95 58                 sta   FrctA,x
1538 2562 CA                    dex   
1539 2563 CA                    dex   
1540 2564 10 F8                 bpl   z2s1
1541 2566 A6 2E                 ldx   fence
1542 2568 BC 81 1B              ldy   StkBtWd,x                ;; SBWord := max (lgthA, MaxShft,x)
1543 256B C4 42                 cpy   lgthA                    ;StkBtWd,x - lgthA
1544 256D 10 02                 bpl   z2s3
1545 256F A4 42                 ldy   lgthA
1546 2571 84 34        z2s3     sty   SBWord                   ;maximum length, i.e., max (lgthA, MaxShft,x)
1547 2573 38                    sec                            ;expnX := -expnX
1548 2574 A5 38                 lda   ZeroWord
1549 2576 E5 BE                 sbc   expnX
1550 2578 85 BE                 sta   expnX
1551 257A A5 38                 lda   ZeroWord
1552 257C E5 C0                 sbc   expnX+2
1553 257E 85 C0                 sta   expnX+2
1554 2580 20 D2 30     DMC      jsr   dnrmC
1555 2583 A6 56                 ldx   lgthC
1556 2585 E4 42        z3s1     cpx   lgthA                    ;lgthC - lgthA
1557 2587 10 08                 bpl   z3s2
1558 2589 E8                    inx   
1559 258A E8                    inx   
1560 258B 86 56                 stx   lgthC                    ;extend length of C to A
1561 258D 74 8C                 stz   FrctC,X
1562 258F 10 F4                 bpl   z3s1                     ;branch always  !!!!!!!!!!!!!!!!
1563 2591 A5 46        z3s2     lda   signB
1564 2593 45 50                 eor   signC
1565 2595 D0 3D                 bne   diffSgn
1566 2597 A6 42                 ldx   lgthA
1567 2599 18                    clc   
1568 259A B5 58        z3s5     lda   FrctA,x
1569 259C 75 8C                 adc   FrctC,x
1570 259E 95 8C                 sta   FrctC,x
1571 25A0 CA                    dex   
1572 25A1 CA                    dex   
1573 25A2 10 F6                 bpl   z3s5
1574 25A4 90 2D                 bcc   z3s10                    ;no carry overflow
1575 25A6 A6 56                 ldx   lgthC
1576 25A8 9B                    txy   
1577 25A9 A6 38                 ldx   ZeroWord
1578 25AB 76 8C        z3s6     ror   FrctC,x
1579 25AD E8                    inx   
1580 25AE 88                    dey   
1581 25AF E8                    inx   
1582 25B0 88                    dey   
1583 25B1 10 F8                 bpl   z3s6
1584 25B3 E6 52                 inc   expnC                    ;adjust exponent
1585 25B5 D0 02                 bne   z3s7
1586 25B7 E6 54                 inc   expnC+2
1587 25B9 90 18        z3s7     bcc   z3s10                    ;no carry from right bit shift
1588 25BB A6 56                 ldx   lgthC
1589 25BD E4 34                 cpx   SBWord                   ;lgthC - SBWord
1590 25BF 90 07                 bcc   z3s8                     ;lgthC < SBWord
1591 25C1 B5 8C                 lda   FrctC,x
1592 25C3 09 01 00              ora   #$1                      ;or carry out, into last bit of FrctC,x
1593 25C6 D0 09                 bne   z3s9                     ;always true
1594 25C8 E8           z3s8     inx                            ;add new word with a leading bit set
1595 25C9 E8                    inx   
1596 25CA 86 56                 stx   lgthC
1597 25CC E6 26                 inc   tmpZP2                   ;update word length
1598 25CE A9 00 80              lda   #$8000
1599 25D1 95 8C        z3s9     sta   FrctC,x
1600 25D3 60           z3s10    rts   
1601 25D4 A6 42        diffSgn  ldx   lgthA
1602 25D6 E4 56        z4s1     cpx   lgthC                    ;lgthA - lgthC
1603 25D8 10 08                 bpl   z4s2
1604 25DA E8                    inx   
1605 25DB E8                    inx   
1606 25DC 86 42                 stx   lgthA                    ;extend length of A to C
1607 25DE 74 58                 stz   FrctA,X
1608 25E0 10 F4                 bpl   z4s1                     ;branch always  !!!!!!!!!!!!!!!!
1609 25E2 38           z4s2     sec   
1610 25E3 B5 58        z4s5     lda   FrctA,x
1611 25E5 F5 8C                 sbc   FrctC,x
1612 25E7 95 8C                 sta   FrctC,x
1613 25E9 CA                    dex   
1614 25EA CA                    dex   
1615 25EB 10 F6                 bpl   z4s5
1616 25ED B0 11                 bcs   NrmlzC                   ;|A| >= |C|
1617 25EF A6 56                 ldx   lgthC                    ;negate result
1618 25F1 38                    sec   
1619 25F2 A5 38        z4s6     lda   ZeroWord
1620 25F4 F5 8C                 sbc   FrctC,x
1621 25F6 95 8C                 sta   FrctC,x
1622 25F8 CA                    dex   
1623 25F9 CA                    dex   
1624 25FA 10 F6                 bpl   z4s6
1625 25FC A5 46                 lda   signB                    ;change sign
1626 25FE 85 50                 sta   signC
1627 2600                       EXPORT NrmlzC 
1628 2600              NrmlzC                                  ;       
1629 2600 A5 8C                 lda   FrctC
1630 2602 D0 44                 bne   NrmBitC                  ;leading word non zero
1631 2604 A2 FE FF              ldx   #-2
1632 2607 A5 56                 lda   lgthC
1633 2609 F0 19                 beq   ZrRslt                   ;zero result
1634 260B 4A                    lsr   a                        ;number of word shifts
1635 260C E8           z5s1     inx   
1636 260D E8                    inx   
1637 260E B4 8E                 ldy   FrctC+2,x
1638 2610 94 8C                 sty   FrctC,x
1639 2612 3A                    dec   a
1640 2613 D0 F7                 bne   z5s1
1641 2615 86 56                 stx   lgthC                    ;store updated length of C
1642 2617 A5 52                 lda   expnC                    ;Note: carry cleared by 'lsr' above
1643 2619 E9 0F 00              sbc   #$0f                     ;really expnC := expnC - 16.
1644 261C 85 52                 sta   expnC
1645 261E B0 E0                 bcs   NrmlzC
1646 2620 C6 54                 dec   expnC+2
1647 2622 90 DC                 bcc   NrmlzC                   ;branch always
1648 2624 64 50        ZrRslt   stz   signC
1649 2626 A5 1C                 lda   EnvWrd
1650 2628 29 00 C0              and   #$0c000                  ;mask in rounding direction
1651 262B 0A                    asl   a
1652 262C 90 04                 bcc   z6s1
1653 262E D0 02                 bne   z6s1                     ;RZ
1654 2630 26 50                 rol   signC
1655 2632 4C 31 1F     z6s1     jmp   rtnZero
1656 2635 A6 56        loopNBC  ldx   lgthC
1657 2637 18                    clc   
1658 2638 36 8C        z7s3     rol   FrctC,x
1659 263A CA                    dex   
1660 263B CA                    dex   
1661 263C 10 FA                 bpl   z7s3
1662 263E A5 52                 lda   expnC
1663 2640 D0 02                 bne   z7s4
1664 2642 C6 54                 dec   expnC+2
1665 2644 C6 52        z7s4     dec   expnC
1666 2646 A5 8C                 lda   FrctC
1667 2648 10 EB        NrmBitC  bpl   loopNBC
1668 264A 60                    rts   
1669 264B              ;                                       ;A div B
1670 264B                       EXPORT Xdiv 
1671 264B              Xdiv                                    ;       
1672 264B A6 3A                 ldx   Atag
1673 264D 30 10                 bmi   z8s5
1674 264F A4 44                 ldy   Btag
1675 2651 10 1C                 bpl   BgnDiv                   ;no special cases
1676 2653 C8                    iny   
1677 2654 30 10                 bmi   z8s6                     ;B is infinity and A is a number, return zero
1678 2656              ;                                       ;B is zero and A is a number, return infinity
1679 2656 A9 08 00              lda   #dvzxcp
1680 2659 20 50 1F              jsr   setXcpn                  ;signal div_zero
1681 265C 4C 36 1F     z8s4     jmp   rtnInf
1682 265F E4 44        z8s5     cpx   Btag
1683 2661 F0 06                 beq   z8s7                     ;0/0 or infinity/infinity
1684 2663 E8                    inx   
1685 2664 30 F6                 bmi   z8s4                     ;A is infinity and B is not, return infinity
1686 2666              ;                                       ;A is zero and B is not zero, return zero
1687 2666 4C 31 1F     z8s6     jmp   rtnZero
1688 2669 A9 04 40     z8s7     lda   #NanDiv
1689 266C 4C 41 1F              jmp   InvNan
1690 266F 20 29 27     BgnDiv   jsr   rtab1X                   ;right shift A and B one bit
1691 2672              ;                                       ;& extend the length of A to B if necessary
1692 2672 A6 30                 ldx   fence2                   ;format of destination
1693 2674 BD AD 1B              lda   MaxShft,x
1694 2677 85 26                 sta   tmpZP2
1695 2679 46 26                 lsr   tmpZP2                   ;divide by 16, to find the # of word divides
1696 267B 46 26                 lsr   tmpZP2
1697 267D 46 26                 lsr   tmpZP2
1698 267F 46 26                 lsr   tmpZP2                   ;number of full word divides
1699 2681 29 0F 00              and   #$0f
1700 2684 85 28                 sta   tmpZP3                   ;number of bit divides for last word
1701 2686 64 56                 stz   lgthC                    ;initialize length of 'C'
1702 2688 20 F4 26     z9s4     jsr   dvword                   ;divide a word
1703 268B A6 56                 ldx   lgthC
1704 268D A5 24                 lda   tmpZP
1705 268F 95 8C                 sta   FrctC,x                  ;store byte of quotient
1706 2691 E6 56                 inc   lgthC
1707 2693 E6 56                 inc   lgthC
1708 2695 C6 26                 dec   tmpZP2
1709 2697 D0 EF                 bne   z9s4
1710 2699 A4 28                 ldy   tmpZP3
1711 269B 20 F7 26              jsr   dvword2
1712 269E A5 24                 lda   tmpZP
1713 26A0 4A                    lsr   a
1714 26A1 6A           z9s5     ror   a                        ;adjust last word of quotient
1715 26A2 C6 28                 dec   tmpZP3
1716 26A4 D0 FB                 bne   z9s5
1717 26A6 A6 56                 ldx   lgthC
1718 26A8 95 8C                 sta   FrctC,x                  ;store word of quotient
1719 26AA A6 42                 ldx   lgthA
1720 26AC B5 58        z9s7     lda   FrctA,x                  ;check for sticky bit loop
1721 26AE D0 06                 bne   z9s8                     ;found a sticky bit
1722 26B0 CA                    dex   
1723 26B1 CA                    dex   
1724 26B2 10 F8                 bpl   z9s7
1725 26B4 30 09                 bmi   z9s9                     ;branch always, no sticky bit
1726 26B6 A6 56        z9s8     ldx   lgthC
1727 26B8 A9 01 00              lda   #$1
1728 26BB 15 8C                 ora   FrctC,x                  ;or in sticky bit
1729 26BD 95 8C                 sta   FrctC,x                  ;store sticky bit
1730 26BF 38           z9s9     sec   
1731 26C0 A5 3E                 lda   expnA
1732 26C2 E5 48                 sbc   expnB
1733 26C4 85 52                 sta   expnC
1734 26C6 A5 40                 lda   expnA+2
1735 26C8 E5 4A                 sbc   expnB+2
1736 26CA 85 54                 sta   expnC+2
1737 26CC A5 8C                 lda   FrctC
1738 26CE 0A                    asl   a
1739 26CF B0 09                 bcs   z9s13                    ;leading bit set, no left shift necessary
1740 26D1 A6 56                 ldx   lgthC
1741 26D3 18                    clc   
1742 26D4 36 8C        z9s12    rol   FrctC,x
1743 26D6 CA                    dex   
1744 26D7 CA                    dex   
1745 26D8 10 FA                 bpl   z9s12
1746 26DA A5 52        z9s13    lda   expnC                    ;adjust exponent
1747 26DC 69 FE 3F              adc   #$3ffe
1748 26DF 85 52                 sta   expnC
1749 26E1 A5 54                 lda   expnC+2
1750 26E3 65 38                 adc   ZeroWord
1751 26E5 85 54                 sta   expnC+2
1752 26E7 A6 56        z9s15    ldx   lgthC                    ;strip trailing zero word loop
1753 26E9 B5 8C                 lda   FrctC,x
1754 26EB D0 06                 bne   z9s20                    ;word contains a bit, exit loop
1755 26ED C6 56                 dec   lgthC
1756 26EF C6 56                 dec   lgthC
1757 26F1 10 F4                 bpl   z9s15
1758 26F3 60           z9s20    rts   
1759 26F4 A0 10 00     dvword   ldy   #$10                     ;set bit counter
1760 26F7 64 24        dvword2  stz   tmpZP                    ;initialize quotient word
1761 26F9 A5 58        dvword3  lda   FrctA
1762 26FB C5 72                 cmp   FrctB                    ;compares MSB of FrctA - FrctB
1763 26FD 90 1B                 bcc   z10s4                    ;early bypass, FrctA < FrctB
1764 26FF A6 4C                 ldx   lgthB                    ;carry is set
1765 2701 B5 58        z10s2    lda   FrctA,x
1766 2703 F5 72                 sbc   FrctB,x                  ;FrctA := FrctA - FrctB loop
1767 2705 95 58                 sta   FrctA,x
1768 2707 CA                    dex   
1769 2708 CA                    dex   
1770 2709 10 F6                 bpl   z10s2
1771 270B B0 0D                 bcs   z10s4                    ;FrctA - FrctB >= 0
1772 270D A6 4C                 ldx   lgthB                    ;carry is clear
1773 270F B5 58        z10s3    lda   FrctA,x
1774 2711 75 72                 adc   FrctB,x                  ;restore loop
1775 2713 95 58                 sta   FrctA,x
1776 2715 CA                    dex   
1777 2716 CA                    dex   
1778 2717 10 F6                 bpl   z10s3
1779 2719 18                    clc   
1780 271A 26 24        z10s4    rol   tmpZP
1781 271C A6 42                 ldx   lgthA
1782 271E 18                    clc   
1783 271F 36 58        z10s5    rol   FrctA,x                  ;left shift 'A'
1784 2721 CA                    dex   
1785 2722 CA                    dex   
1786 2723 10 FA                 bpl   z10s5
1787 2725 88                    dey                            ;decremet bit counter
1788 2726 D0 D1                 bne   dvWord3
1789 2728 60                    rts   
1790 2729 A6 38        rtab1X   ldx   ZeroWord                 ;shift anm "1" bit to right ********
1791 272B A5 42                 lda   lgthA
1792 272D 4A                    lsr   a                        ;divide by 2, i.e. number of words in 'A'
1793 272E              ;      ;clc	            ;Note:	above instruction clears carry
1794 272E 76 58        z11s1    ror   FrctA,x                  ;right shift byte
1795 2730 E8                    inx   
1796 2731 E8                    inx   
1797 2732 3A                    dec   a
1798 2733 10 F9                 bpl   z11s1
1799 2735 90 06                 bcc   rtb1                     ;no carry bit
1800 2737 86 42                 stx   lgthA                    ;store incremented anm
1801 2739 74 58                 stz   FrctA,X
1802 273B 76 58                 ror   FrctA,x                  ;shift in carry
1803 273D A6 38        rtb1     ldx   ZeroWord                 ;shift anm "1" bit to right ********
1804 273F A5 4C                 lda   lgthB
1805 2741 4A                    lsr   a                        ;divide by 2, i.e. number of words in 'B'
1806 2742              ;      ;clc	            ;Note:	above instruction clears carry
1807 2742 76 72        z12s1    ror   FrctB,x                  ;right shift byte
1808 2744 E8                    inx   
1809 2745 E8                    inx   
1810 2746 3A                    dec   a
1811 2747 10 F9                 bpl   z12s1
1812 2749 90 06                 bcc   XAtoB                    ;no carry bit
1813 274B 86 4C                 stx   lgthB                    ;store incremented anm
1814 274D 74 72                 stz   FrctB,X
1815 274F 76 72                 ror   FrctB,x                  ;shift in carry
1816 2751 A6 42        XAtoB    ldx   lgthA
1817 2753 E4 4C        z13s1    cpx   lgthB                    ;lgthA - lgthB
1818 2755 B0 08                 bcs   z13s2                    ;lgthA >= lgthB
1819 2757 E8                    inx   
1820 2758 E8                    inx   
1821 2759 86 42                 stx   lgthA                    ;store new length
1822 275B 74 58                 stz   FrctA,X                  ;pad FrctA with zeros
1823 275D 10 F4                 bpl   z13s1                    ;always true
1824 275F 60           z13s2    rts   
1825 2760                       EXPORT rem 
1826 2760              rem                                     ;       
1827 2760 A5 50                 lda   signC
1828 2762 4A                    lsr   a
1829 2763 64 20                 stz   pendingX                 ;put sign of C into pendingX
1830 2765 66 20                 ror   pendingX                 ;in the high bit of both bytes
1831 2767 EB                    xba   
1832 2768 05 20                 ora   pendingX
1833 276A 85 20                 sta   pendingX
1834 276C A5 3C                 lda   signA
1835 276E 85 50                 sta   signC                    ;initialize sign
1836 2770 A5 3A                 lda   atag
1837 2772 A6 44                 ldx   btag
1838 2774 30 03                 bmi   z14s1
1839 2776 A8                    tay   
1840 2777 10 13                 bpl   BgnRem                   ;no special cases
1841 2779 C9 FE FF     z14s1    cmp   #inftag
1842 277C F0 08                 beq   z14s2                    ;g,h,i          infinity rem [ ]
1843 277E E0 FF FF              cpx   #ZeroTag
1844 2781 F0 03                 beq   z14s2                    ;a,d            [ ] rem 0
1845 2783 4C 7D 20              jmp   AtoC                     ;rts     b,c,f     0 rem [w, infinity]
1846 2786              ;                                       ;or w rem infinity
1847 2786 A9 09 40     z14s2    lda   #NaNRem
1848 2789 4C 41 1F              jmp   invNaN                   ;rts
1849 278C 20 29 27     BgnRem   jsr   rtab1X                   ;right shift A and B one bit
1850 278F              ;                                       ;& extend the length of A to B if necessary
1851 278F 64 24                 stz   tmpZP
1852 2791 38                    sec   
1853 2792 A5 3E                 lda   expna
1854 2794 E5 48                 sbc   expnb
1855 2796 85 52                 sta   expnc
1856 2798 A5 40                 lda   expna+2
1857 279A E5 4A                 sbc   expnb+2
1858 279C 85 54                 sta   expnc+2
1859 279E E6 52                 inc   expnC                    ;add 1
1860 27A0 D0 02                 bne   z15s2
1861 27A2 E6 54                 inc   expnC+2
1862 27A4 24 54        z15s2    bit   expnC+2
1863 27A6 30 7C                 bmi   z15s13
1864 27A8 A0 01 00              ldy   #$1
1865 27AB 20 F7 26              jsr   dvword2
1866 27AE A4 52                 ldy   expnC
1867 27B0 F0 03                 beq   z15s3
1868 27B2 20 F9 26              jsr   dvword3
1869 27B5 C6 54        z15s3    dec   expnc+2                  ;sub 1
1870 27B7 30 07                 bmi   z15s5
1871 27B9 A4 38                 ldy   ZeroWord
1872 27BB 20 F9 26              jsr   dvword3                  ;i.e. do 2^16 cycles
1873 27BE 80 F5                 bra   z15s3                    ;always true
1874 27C0 18           z15s5    clc                            ;subtract 1
1875 27C1 A5 48                 lda   ExpnB
1876 27C3 E5 38                 sbc   ZeroWord
1877 27C5 85 52                 sta   ExpnC
1878 27C7 A5 4A                 lda   ExpnB+2
1879 27C9 E5 38                 sbc   ZeroWord
1880 27CB 85 54                 sta   ExpnC+2
1881 27CD 46 24                 lsr   tmpZP
1882 27CF A5 24                 lda   tmpZP
1883 27D1 85 2A                 sta   tmpZP4
1884 27D3 90 39                 bcc   z15s23                   ;a < b/2
1885 27D5 A6 42                 ldx   lgthA
1886 27D7 B5 58        z15s7    lda   FrctA,x
1887 27D9 D0 08                 bne   z15s8                    ;non zero anm
1888 27DB CA                    dex   
1889 27DC CA                    dex   
1890 27DD 10 F8                 bpl   z15s7
1891 27DF 46 24                 lsr   tmpZP
1892 27E1 90 0D                 bcc   z15s9                    ;Q is even
1893 27E3 A5 2A        z15s8    lda   tmpZP4                   ;carry is set
1894 27E5 65 38                 adc   ZeroWord                 ;clears carry, for $9 below
1895 27E7 85 2A                 sta   tmpZP4
1896 27E9 A5 50                 lda   signC
1897 27EB 49 01 00              eor   #$1                      ;change sign
1898 27EE 85 50                 sta   signC
1899 27F0 A6 4C        z15s9    ldx   lgthB
1900 27F2              ;      ;clc
1901 27F2 36 72        z15s10   rol   FrctB,x
1902 27F4 CA                    dex   
1903 27F5 CA                    dex   
1904 27F6 10 FA                 bpl   z15s10
1905 27F8 A6 4C                 ldx   lgthB
1906 27FA E4 42        z15s22   cpx   lgthA
1907 27FC B0 06                 bcs   z15s11                   ; x >= lgthA
1908 27FE E8                    inx   
1909 27FF E8                    inx   
1910 2800 74 72                 stz   FrctB,X
1911 2802 10 F6                 bpl   z15s22                   ; always true
1912 2804 B5 72        z15s11   lda   FrctB,x
1913 2806 F5 58                 sbc   FrctA,x                  ;a := b - a
1914 2808 95 58                 sta   FrctA,x
1915 280A CA                    dex   
1916 280B CA                    dex   
1917 280C 10 F6                 bpl   z15s11
1918 280E A5 2A        z15s23   lda   tmpZP4
1919 2810 29 7F 00              and   #$7f
1920 2813 05 20                 ora   pendingX
1921 2815 85 20                 sta   pendingX
1922 2817 A6 42                 ldx   lgthA
1923 2819 B5 58        z15s12   lda   FrctA,x
1924 281B D0 14                 bne   z15s15
1925 281D CA                    dex   
1926 281E CA                    dex   
1927 281F 10 F8                 bpl   z15s12
1928 2821 4C 31 1F              jmp   rtnZero                  ;rts
1929 2824 38           z15s13   sec                            ;add 1
1930 2825 A5 3E                 lda   expnA
1931 2827 65 38                 adc   ZeroWord
1932 2829 85 52                 sta   expnC
1933 282B A5 40                 lda   expnA+2
1934 282D 65 38                 adc   ZeroWord
1935 282F 85 54                 sta   expnC+2
1936 2831 A6 42        z15s15   ldx   lgthA
1937 2833 86 56                 stx   lgthC
1938 2835 B5 58        z15s16   lda   FrctA,x
1939 2837 95 8C                 sta   FrctC,x
1940 2839 CA                    dex   
1941 283A CA                    dex   
1942 283B 10 F8                 bpl   z15s16
1943 283D AA                    tax   
1944 283E 30 23                 bmi   EndRem
1945 2840                       EXPORT BgnNrmC 
1946 2840              BgnNrmC                                 ;       
1947 2840 A6 56                 ldx   lgthC                    ;left shift one bit
1948 2842 18                    clc   
1949 2843 36 8C        z16s1    rol   FrctC,x
1950 2845 CA                    dex   
1951 2846 CA                    dex   
1952 2847 10 FA                 bpl   z16s1
1953 2849 A5 52                 lda   expnC                    ;increment exponent
1954 284B D0 02                 bne   z16s2
1955 284D C6 54                 dec   expnC+2
1956 284F C6 52        z16s2    dec   expnC
1957 2851 A5 8C        normC    lda   FrctC
1958 2853 10 EB                 bpl   BgnNrmC                  ;still not normalized
1959 2855 A6 56        TailOff  ldx   lgthC
1960 2857 30 0A                 bmi   EndRem
1961 2859 B5 8C        z17s1    lda   FrctC,x                  ;strip trailing zero words
1962 285B D0 06                 bne   EndRem
1963 285D CA                    dex   
1964 285E CA                    dex   
1965 285F 86 56                 stx   lgthC
1966 2861 10 F6                 bpl   z17s1
1967 2863 60           EndRem   rts   
1968 2864                       EXPORT sqrt 
1969 2864              sqrt                                    ;       
1970 2864 A5 46                 lda   signB
1971 2866 85 50                 sta   signC
1972 2868 F0 12                 beq   z18s3                    ;positive argument
1973 286A A5 44                 lda   Btag
1974 286C 10 05                 bpl   z18s1                    ;sqrt of non zero negative number
1975 286E C9 FE FF              cmp   #Inftag
1976 2871 D0 06                 bne   z18s2                    ;either '0' or a Nan
1977 2873 A9 01 40     z18s1    lda   #NanSqrt
1978 2876 4C 41 1F              jmp   InvNaN                   ;rts
1979 2879 4C BB 20     z18s2    jmp   BtoC                     ;rts
1980 287C A5 44        z18s3    lda   Btag
1981 287E 30 F9                 bmi   z18s2
1982 2880 20 3D 27              jsr   rtB1
1983 2883 18                    clc   
1984 2884 A9 01 40              lda   #$4001                   ;(3fff + 2)
1985 2887 65 48                 adc   expnB                    ;adjust exponent and transfer to expnC
1986 2889 85 52                 sta   expnC
1987 288B A5 38                 lda   ZeroWord
1988 288D 65 4A                 adc   expnB+2
1989 288F 85 54                 sta   expnC+2
1990 2891 A5 54                 lda   expnC+2
1991 2893 0A                    asl   a                        ;extend sign
1992 2894 66 54                 ror   expnC+2
1993 2896 66 52                 ror   expnc
1994 2898 B0 03                 bcs   z18s5
1995 289A 20 3D 27              jsr   rtB1
1996 289D A6 2E        z18s5    ldx   fence
1997 289F BC AD 1B              ldy   MaxShft,x
1998 28A2 A9 00 20              lda   #$2000
1999 28A5 64 56                 stz   lgthC                    ;initialize lgthC
2000 28A7 A6 56                 ldx   lgthC
2001 28A9 85 8C                 sta   FrctC
2002 28AB 85 24                 sta   tmpZP                    ;initialize tmpZP
2003 28AD F0 2E                 beq   z18s12                   ;always true
2004 28AF 46 24        z18s8    lsr   tmpZP                    ;right shift mask
2005 28B1 90 1A                 bcc   z18s10                   ;mask ok
2006 28B3 A9 00 80              lda   #$8000
2007 28B6 85 24                 sta   tmpZP                    ;reset mask
2008 28B8 E6 56                 inc   lgthC                    ;expand lgthC
2009 28BA E6 56                 inc   lgthC
2010 28BC A6 56                 ldx   lgthC
2011 28BE 74 8C                 stz   FrctC,X
2012 28C0 A6 4C                 ldx   lgthB
2013 28C2 E4 56                 cpx   lgthC
2014 28C4 B0 06                 bcs   z18s9                    ;lgthB ok
2015 28C6 E8                    inx   
2016 28C7 E8                    inx   
2017 28C8 86 4C                 stx   lgthB                    ;expand lgthB
2018 28CA 74 72                 stz   FrctB,X
2019 28CC 18           z18s9    clc   
2020 28CD A6 4C        z18s10   ldx   lgthB
2021 28CF 36 72        z18s11   rol   FrctB,x                  ;left shift FrctB 1 bit
2022 28D1 CA                    dex   
2023 28D2 CA                    dex   
2024 28D3 10 FA                 bpl   z18s11
2025 28D5 A6 56                 ldx   lgthC
2026 28D7 B5 8C                 lda   FrctC,x
2027 28D9 05 24                 ora   tmpZP
2028 28DB 95 8C                 sta   FrctC,x                  ;or mask with FrctC
2029 28DD A5 72        z18s12   lda   FrctB
2030 28DF C5 8C                 cmp   FrctC
2031 28E1 90 29                 bcc   z18s16                   ;early bypass
2032 28E3 A6 56                 ldx   lgthC
2033 28E5 B5 72        z18s13   lda   FrctB,x                  ;subtact loop
2034 28E7 F5 8C                 sbc   FrctC,x
2035 28E9 95 72                 sta   FrctB,x
2036 28EB CA                    dex   
2037 28EC CA                    dex   
2038 28ED 10 F6                 bpl   z18s13
2039 28EF A6 56                 ldx   lgthC
2040 28F1 90 0F                 bcc   z18s15                   ;lgthB < lgthC
2041 28F3 18                    clc   
2042 28F4 A5 24                 lda   tmpZP
2043 28F6 75 8C        z18s14   adc   FrctC,x                  ;add mask i.e. really 2*mask
2044 28F8 95 8C                 sta   FrctC,x
2045 28FA 90 18                 bcc   z18s17
2046 28FC A5 38                 lda   ZeroWord
2047 28FE CA                    dex   
2048 28FF CA                    dex   
2049 2900 10 F4                 bpl   z18s14
2050 2902 B5 72        z18s15   lda   FrctB,x
2051 2904 75 8C                 adc   FrctC,x                  ;restore FrctB loop
2052 2906 95 72                 sta   FrctB,x
2053 2908 CA                    dex   
2054 2909 CA                    dex   
2055 290A 10 F6                 bpl   z18s15
2056 290C A6 56        z18s16   ldx   lgthC
2057 290E A5 24                 lda   tmpZP
2058 2910 55 8C                 eor   FrctC,x                  ;restore FrctC
2059 2912 95 8C                 sta   FrctC,x
2060 2914 88           z18s17   dey   
2061 2915 10 98                 bpl   z18s8                    ;need another bit
2062 2917 A6 4C                 ldx   lgthB
2063 2919 B5 72        z18s18   lda   FrctB,x
2064 291B D0 06                 bne   z18s19                   ;sticky bit found
2065 291D CA                    dex   
2066 291E CA                    dex   
2067 291F 10 F8                 bpl   z18s18
2068 2921 30 08                 bmi   z18s20                   ;always true, no sticky bit found
2069 2923 A6 56        z18s19   ldx   lgthC
2070 2925 A5 24                 lda   tmpZP
2071 2927 15 8C                 ora   FrctC,x                  ;insert sticky bit
2072 2929 95 8C                 sta   FrctC,x
2073 292B 4C 40 28     z18s20   jmp   BgnNrmC                  ;rts
2074 292E                       ENDP 
2075 292E              ;          copy sane/b2d2b
2076 292E              ;he     ''B2D2B'17 April 86
2077 292E              ;fo     ''%'klh
2078 292E              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
2079 292E              ;; File:  B2D2B
2080 292E              ;; Description: Binary <--> Decimal for ORCA SANE 65816 floating point engine
2081 292E              ;; Status: Alpha
2082 292E              ;;
2083 292E              ;; Written by Kenton Hanson, Apple Numerics Group, 17 April 1986
2084 292E              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
2085 292E                       EXPORT B2D 
2086 292E              B2D      PROC 
2087 292E 68 85 14 68           pop   Argstr                   ;pointer to decimal record
2088 2934 20 DA 20              jsr   UnPck                    ;pointer to source (Brgstr)
2089 2937 68 85 0C 68           pop   Crgstr                   ;pointer to format record
2090 293D A4 38                 ldy   ZeroWord
2091 293F B7 0C                 lda   [Crgstr],y
2092 2941 85 AC                 sta   style
2093 2943 A5 46                 lda   signB
2094 2945 97 14                 sta   [Argstr],y
2095 2947 C8                    iny   
2096 2948 C8                    iny   
2097 2949 B7 0C                 lda   [Crgstr],y
2098 294B 85 AE                 sta   digits
2099 294D A5 44                 lda   Btag
2100 294F 10 5E                 bpl   NzFnVal                  ;Nonzero Finite Value
2101 2951                       longa off
2102 2951                       longi off
2103 2951 E2 30                 sep   #$30
2104 2953 49 FF                 eor   #$0ff                    ;negate Btag and subtract 1
2105 2955 AA                    tax   
2106 2956 BD CB 1B              lda   ZINS,x                   ;get character for zero, infinity or NaN
2107 2959 A0 05                 ldy   #BgnSgDg+1
2108 295B 97 14                 sta   [argstr],y
2109 295D E0 02                 cpx   #$02
2110 295F A9 01                 lda   #$01
2111 2961 90 31                 bcc   z1s3                     ;x < 2
2112 2963 A6 4C                 ldx   lgthB
2113 2965 E8                    inx   
2114 2966 E8                    inx   
2115 2967 86 24                 stx   TmpZP                    ;lgthB + 2
2116 2969 A2 00                 ldx   #$00
2117 296B B5 73        z1s2     lda   FrctB+1,x
2118 296D 4A                    lsr   a
2119 296E 4A                    lsr   a
2120 296F 4A                    lsr   a
2121 2970 4A                    lsr   a
2122 2971 20 9F 29              jsr   Nib2Hex
2123 2974 B5 73                 lda   FrctB+1,x
2124 2976 29 0F                 and   #$0f
2125 2978 20 9F 29              jsr   Nib2Hex
2126 297B B5 72                 lda   FrctB,x
2127 297D 4A                    lsr   a
2128 297E 4A                    lsr   a
2129 297F 4A                    lsr   a
2130 2980 4A                    lsr   a
2131 2981 20 9F 29              jsr   Nib2Hex
2132 2984 B5 72                 lda   FrctB,x
2133 2986 29 0F                 and   #$0f
2134 2988 20 9F 29              jsr   Nib2Hex
2135 298B E8                    inx   
2136 298C E8                    inx   
2137 298D E4 24                 cpx   TmpZP
2138 298F 90 DA                 bcc   z1s2                     ;x < lgthB + 2
2139 2991 98                    tya   
2140 2992 E9 04                 sbc   #BgnSgDg                 ;carry was set
2141 2994 A0 04        z1s3     ldy   #BgnSgDg
2142 2996 97 14                 sta   [argstr],y
2143 2998 C2 30                 rep   #$30
2144 299A 4C 2D 20              jmp   TrpHd1                   ;rts
2145 299D E2 30                 sep   #$30
2146 299F C9 0A        Nib2Hex  cmp   #$0a
2147 29A1 B0 04                 bcs   z2s5                     ;a > 9
2148 29A3 09 30                 ora   #$30
2149 29A5 90 02                 bcc   z2s6                     ;always true
2150 29A7 69 56        z2s5     adc   #$56
2151 29A9 C8           z2s6     iny   
2152 29AA 97 14                 sta   [argstr],y
2153 29AC 60                    rts   
2154 29AD                       longa on
2155 29AD                       longi on
2156 29AD C2 30                 rep   #$30
2157 29AF A9 0E 00     NzFnVal  lda   #ffqq
2158 29B2 85 30                 sta   fence2                   ;max precision for scaled integer
2159 29B4 A5 AC                 lda   style
2160 29B6 D0 0A                 bne   z3s9                     ;style is fixed
2161 29B8 A5 AE                 lda   digits
2162 29BA 30 02                 bmi   z3s8                     ;digits < 0
2163 29BC D0 04                 bne   z3s9                     ;digits > 0
2164 29BE 64 AE        z3s8     stz   digits
2165 29C0 E6 AE                 inc   digits                   ;set digits to 1
2166 29C2 20 BB 2A     z3s9     jsr   BtoE                     ;save B, restore if length > len
2167 29C5 20 11 2C              jsr   fplog10                  ;get a floor log10 of source, (ilog)
2168 29C8 38           b2dLoop  sec   
2169 29C9 A5 AC                 lda   style
2170 29CB D0 06                 bne   z4s11                    ;style is fixed
2171 29CD A5 AE                 lda   digits
2172 29CF 85 A6                 sta   len                      ;len := digits
2173 29D1 B0 06                 bcs   z4s12                    ;always true !!!!!!!!!!!!
2174 29D3 A5 A8        z4s11    lda   ilog
2175 29D5 65 AE                 adc   digits
2176 29D7 85 A6                 sta   len                      ;len := ilog + digits + 1
2177 29D9 30 0D        z4s12    bmi   z4s13                    ;len < 0
2178 29DB 38                    sec                            ;len > SigDigLn ?
2179 29DC A9 1C 00              lda   #SigDigLn
2180 29DF E5 A6                 sbc   len
2181 29E1 10 05                 bpl   z4s13                    ;no
2182 29E3 A9 1C 00              lda   #SigDigLn
2183 29E6 85 A6                 sta   len                      ;len := SigDigLn
2184 29E8 18           z4s13    clc   
2185 29E9 A5 A6                 lda   len
2186 29EB E5 A8                 sbc   ilog
2187 29ED 85 AA                 sta   iscale                   ;iscale := len - ilog - 1
2188 29EF 85 24                 sta   tmpZP
2189 29F1 A5 A6                 lda   len
2190 29F3 30 02                 bmi   z4s91
2191 29F5 D0 04                 bne   z4s92
2192 29F7 64 A6        z4s91    stz   len                      ;len < 1, len := 1
2193 29F9 E6 A6                 inc   len
2194 29FB A0 02 00     z4s92    ldy   #$02
2195 29FE 38                    sec   
2196 29FF A5 38                 lda   ZeroWord
2197 2A01 E5 AA                 sbc   iscale
2198 2A03 97 14                 sta   [argstr],y               ;exp := ilog + 1 - len (= -iscale)
2199 2A05 20 B3 2B              jsr   ScaleIt
2200 2A08 20 87 2D              jsr   Rnd2Int
2201 2A0B 64 58        I2ASCII  stz   FrctA                    ;initialize FrctA
2202 2A0D 64 42                 stz   lgthA
2203 2A0F A5 4E                 lda   Ctag
2204 2A11 30 59                 bmi   z5s9                     ;case of integer zero
2205 2A13 64 28                 stz   tmpZP3                   ;number of words in FrctA
2206 2A15 38                    sec   
2207 2A16 A5 52                 lda   expnC
2208 2A18 E9 FF 3F              sbc   #$3fff
2209 2A1B 85 2C                 sta   tmpZP5
2210 2A1D 29 0F 00              and   #$0f
2211 2A20 85 2A                 sta   tmpZP4                   ;number of bits in last word
2212 2A22 46 2C                 lsr   tmpZP5
2213 2A24 46 2C                 lsr   tmpZP5
2214 2A26 46 2C                 lsr   tmpZP5
2215 2A28 46 2C                 lsr   tmpZP5                   ;location of last word
2216 2A2A 64 C2                 stz   lgthX                    ;initialize pointer to Frctc
2217 2A2C F8                    sed                            ;set decimal mode
2218 2A2D A6 C2        z5s2     ldx   lgthX
2219 2A2F E4 56                 cpx   lgthC                    ;lgthX - lgthC
2220 2A31 F0 02                 beq   z5s3
2221 2A33 10 04                 bpl   z5s4                     ;assumes tmpZP is '0' from last pass
2222 2A35 B5 8C        z5s3     lda   FrctC,x                  ;get next word
2223 2A37 85 24                 sta   tmpZP
2224 2A39 E6 C2        z5s4     inc   lgthX
2225 2A3B E6 C2                 inc   lgthX                    ;set pointer to next word of FrctC
2226 2A3D A9 0F 00              lda   #$0f                     ;INITIALIZE BIT COUNT
2227 2A40 C6 2C                 dec   tmpZP5
2228 2A42 10 02                 bpl   z5s5                     ;do entire word of FrctC
2229 2A44 A5 2A                 lda   tmpZP4                   ;do partial word of FrctC
2230 2A46 85 26        z5s5     sta   tmpZP2                   ;number of bit shifts
2231 2A48 A6 38        z5s6     ldx   ZeroWord
2232 2A4A A4 28                 ldy   tmpZP3
2233 2A4C 06 24                 asl   tmpZP                    ;sets carry for add loop
2234 2A4E B5 58        z5s7     lda   FrctA,X                  ;ADD LOOP
2235 2A50 75 58                 adc   FrctA,X
2236 2A52 95 58                 sta   FrctA,X
2237 2A54 E8                    inx   
2238 2A55 E8                    inx   
2239 2A56 88                    dey   
2240 2A57 10 F5                 bpl   z5s7
2241 2A59 90 08                 bcc   z5s8                     ;NO CARRY PROPAGATION
2242 2A5B 74 58                 stz   FrctA,X                  ;zero new word
2243 2A5D 36 58                 rol   FrctA,x                  ;shift in carry
2244 2A5F 86 42                 stx   lgthA                    ;store new length
2245 2A61 E6 28                 inc   tmpZP3                   ;increment word count
2246 2A63 C6 26        z5s8     dec   tmpZP2
2247 2A65 10 E1                 bpl   z5s6
2248 2A67 24 2C                 bit   tmpZP5
2249 2A69 10 C2                 bpl   z5s2
2250 2A6B D8                    cld                            ;CLEAR DECIMAL MODE
2251 2A6C              z5s9      
2252 2A6C                       longa off
2253 2A6C                       longi off
2254 2A6C E2 30                 sep   #$30
2255 2A6E A0 04                 ldy   #BgnSgDg                 ;BEGIN BCD TO ASCII
2256 2A70 38                    sec   
2257 2A71 98                    tya   
2258 2A72 65 A6                 adc   len
2259 2A74 85 24                 sta   tmpZP                    ;max string location in decimal record
2260 2A76 A6 42                 ldx   lgthA
2261 2A78 B5 59                 lda   FrctA+1,x
2262 2A7A F0 01                 beq   z5s10                    ;high byte is zero
2263 2A7C E8                    inx                            ;increment x to start with high byte
2264 2A7D A9 F0        z5s10    lda   #$0f0
2265 2A7F 35 58                 and   FrctA,x
2266 2A81 F0 0F                 beq   z5s13                    ;leading nibble is zero
2267 2A83 B5 58        z5s11    lda   FrctA,X
2268 2A85 4A           z5s12    lsr   A
2269 2A86 4A                    lsr   A
2270 2A87 4A                    lsr   A
2271 2A88 4A                    lsr   A
2272 2A89 09 30                 ora   #$30
2273 2A8B C8                    iny   
2274 2A8C C4 24                 cpy   tmpZP
2275 2A8E B0 1F                 bcs   z5s99                    ;length (FrctA) > len
2276 2A90 97 14                 sta   [argstr],Y
2277 2A92 B5 58        z5s13    lda   FrctA,X
2278 2A94 29 0F                 and   #$0F
2279 2A96 09 30                 ora   #$30
2280 2A98 C8                    iny   
2281 2A99 C4 24                 cpy   tmpZP
2282 2A9B B0 12                 bcs   z5s99                    ;length (FrctA) > len
2283 2A9D 97 14                 sta   [argstr],Y
2284 2A9F CA                    dex   
2285 2AA0 10 E1                 bpl   z5s11
2286 2AA2 38                    sec   
2287 2AA3 98                    tya   
2288 2AA4 E9 04                 sbc   #BgnSgDg
2289 2AA6 A0 04                 ldy   #BgnSgDg
2290 2AA8 97 14                 sta   [argstr],Y
2291 2AAA                       longa on
2292 2AAA                       longi on
2293 2AAA C2 30                 rep   #$30
2294 2AAC 4C 2D 20              jmp   TrpHd1                   ;rts
2295 2AAF C2 30        z5s99    rep   #$30
2296 2AB1              ;                                       ;restore bnm
2297 2AB1              ;      ;R2R     E,B
2298 2AB1 20 56 2B              jsr   EtoB
2299 2AB4 64 1E                 stz   tmpflgs                  ;clear flags
2300 2AB6 E6 A8                 inc   ilog                     ;ilog := ilog + 1
2301 2AB8 4C C8 29              jmp   b2dLoop
2302 2ABB A5 44 85 B0           RtoR B,E
2303 2ADA A5 44 85 BA           RtoR B,X
2304 2AF9 A5 4E 85 44           RtoR C,B
2305 2B18 A5 4E 85 BA           RtoR C,X
2306 2B37 A5 B0 85 3A           RtoR E,A
2307 2B56 A5 B0 85 44           RtoR E,B
2308 2B75 A5 BA 85 3A           RtoR X,A
2309 2B94 A5 BA 85 44           RtoR X,B
2310 2BB3                       EXPORT ScaleIt 
2311 2BB3              ScaleIt                                 ;       
2312 2BB3 D0 03                 bne   z6s1
2313 2BB5 4C BB 20              jmp   BtoC                     ;iscale = 0, jsr & rts
2314 2BB8 85 2C        z6s1     sta   tmpZP5
2315 2BBA 30 02                 bmi   z6s2
2316 2BBC 85 AA                 sta   iscale                   ;iscale := -iscale (= exp)
2317 2BBE A5 1C        z6s2     lda   EnvWrd
2318 2BC0 29 00 C0              and   #$0c000                  ;mask for rounding direction
2319 2BC3 48                    pha                            ;save rounding mode
2320 2BC4              ;      ;lda     EnvWrd
2321 2BC4 0A                    asl   a
2322 2BC5 64 32                 stz   fenceSv                  ;build a pointer for rounding table
2323 2BC7 26 32                 rol   fenceSv                  ;get rounding direction into pointer
2324 2BC9 0A                    asl   a
2325 2BCA 26 32                 rol   fenceSv
2326 2BCC F0 14                 beq   z6s3                     ;rounding mode is round to nearest
2327 2BCE 06 24                 asl   tmpZP                    ;get original signed iscale
2328 2BD0 26 32                 rol   fenceSv                  ;get sign of iscale into pointer
2329 2BD2 A5 46                 lda   signB
2330 2BD4 4A                    lsr   a
2331 2BD5 26 32                 rol   fenceSv                  ;get sign of sign into pointer
2332 2BD7 26 32                 rol   fenceSv
2333 2BD9 A6 32                 ldx   fenceSv
2334 2BDB BD C7 1B              lda   RndTbl-8,x
2335 2BDE 45 1C                 eor   EnvWrd                   ;alter rounding direction according to
2336 2BE0 85 1C                 sta   EnvWrd                   ;the Rounding Table, x
2337 2BE2 20 50 2C     z6s3     jsr   ten
2338 2BE5 A5 B2                 lda   signE
2339 2BE7 85 50                 sta   signC
2340 2BE9 20 37 2B              jsr   EtoA
2341 2BEC A9 FF 3F              lda   #$3fff
2342 2BEF 25 1C                 and   EnvWrd
2343 2BF1 85 1C                 sta   EnvWrd
2344 2BF3 68                    pla   
2345 2BF4 05 1C                 ora   EnvWrd                   ;restore rounding direction
2346 2BF6 85 1C                 sta   EnvWrd
2347 2BF8 A6 30                 ldx   fence2
2348 2BFA 86 2E                 stx   fence
2349 2BFC BC 81 1B              ldy   StkBtWd,x                ;; tmpZP2 := max (lgthA, MaxShft,x)
2350 2BFF C4 42                 cpy   lgthA                    ;StkBtWd,x - lgthC
2351 2C01 10 02                 bpl   z6s4
2352 2C03 A4 42                 ldy   lgthA
2353 2C05 84 34        z6s4     sty   SBWord                   ;maximum length, i.e., max (lgthA, MaxShft,x)
2354 2C07 24 2C                 bit   tmpZP5                   ;get original signed -iscale
2355 2C09 10 03                 bpl   z6s5                     ;exp > 0
2356 2C0B 4C 1C 30              jmp   mul                      ;jsr & rts
2357 2C0E 4C 4B 26     z6s5     jmp   Xdiv                     ;jsr & rts
2358 2C11 A9 1F 9A     FPLog10  lda   #$9a1f                   ;1 less than 2*log2, carry set below
2359 2C14 85 24                 sta   tmpZP
2360 2C16 38                    sec   
2361 2C17 A5 48                 lda   expnB
2362 2C19 E9 FF 3F              sbc   #$3fff                   ;unbias exponent into twos complement form
2363 2C1C A8                    tay   
2364 2C1D 85 26                 sta   tmpZP2
2365 2C1F 85 28                 sta   tmpZP3                   ;used to generate sign extend below
2366 2C21 10 02                 bpl   z7s1
2367 2C23 E6 24                 inc   tmpZP                    ;increment log2 if unbiased exponent < 0
2368 2C25 A5 72        z7s1     lda   FrctB
2369 2C27 85 2A                 sta   tmpZP4
2370 2C29 A5 38                 lda   ZeroWord
2371 2C2B A2 0F 00              ldx   #$0f
2372 2C2E 46 2A        z7s2     lsr   tmpZP4                   ;multiply fraction part times log2
2373 2C30 90 02                 bcc   z7s3
2374 2C32 65 24                 adc   tmpZP                    ;note carry is set (see comment above)
2375 2C34 6A           z7s3     ror   a
2376 2C35 CA                    dex   
2377 2C36 D0 F6                 bne   z7s2
2378 2C38 A2 11 00              ldx   #$11
2379 2C3B 06 28                 asl   tmpZP3
2380 2C3D 66 26        z7s4     ror   tmpZP2                   ;multiply exponent part times log2
2381 2C3F 90 02                 bcc   z7s5
2382 2C41 65 24                 adc   tmpZP                    ;note carry is set (see comment above)
2383 2C43 6A           z7s5     ror   a
2384 2C44 CA                    dex   
2385 2C45 D0 F6                 bne   z7s4
2386 2C47 BB                    tyx   
2387 2C48 10 03                 bpl   z7s6
2388 2C4A 18                    clc   
2389 2C4B E5 24                 sbc   tmpZP                    ;really add of (2^inf - 1)*tmpZP
2390 2C4D 85 A8        z7s6     sta   ilog                     ;store ilog
2391 2C4F 60                    rts   
2392 2C50 A5 AA        Ten      lda   iscale
2393 2C52 20 A1 2C              jsr   ten15
2394 2C55 46 AA                 lsr   iscale
2395 2C57 46 AA                 lsr   iscale
2396 2C59 46 AA                 lsr   iscale
2397 2C5B 46 AA                 lsr   iscale
2398 2C5D D0 01                 bne   z8s1                     ;iscale > 15
2399 2C5F 60                    rts   
2400 2C60 A2 0E 00     z8s1     ldx   #ffqq
2401 2C63 86 2E                 stx   fence
2402 2C65 BD 81 1B              lda   stkBtWd,x
2403 2C68 85 34                 sta   SBWord
2404 2C6A 20 DA 2A              jsr   BtoX
2405 2C6D 64 50                 stz   signC                    ;set sign of result
2406 2C6F A9 10 00              lda   #$10
2407 2C72 20 A4 2C              jsr   tableX
2408 2C75 4C 8A 2C              jmp   z8s4
2409 2C78 20 94 2B     z8s2     jsr   XtoB
2410 2C7B 20 18 2B              jsr   CtoX
2411 2C7E 20 9C 20     z8s3     jsr   BtoA
2412 2C81 20 1C 30              jsr   mul
2413 2C84 20 F7 22              jsr   ck4URO
2414 2C87 20 F9 2A              jsr   CtoB
2415 2C8A 46 AA        z8s4     lsr   iscale
2416 2C8C 90 F0                 bcc   z8s3
2417 2C8E 20 75 2B              jsr   XtoA
2418 2C91 20 DA 2A              jsr   BtoX
2419 2C94 20 1C 30              jsr   mul
2420 2C97 20 F7 22              jsr   ck4URO
2421 2C9A A5 AA                 lda   iscale
2422 2C9C D0 DA                 bne   z8s2
2423 2C9E 4C F9 2A              jmp   CtoB                     ;rts
2424 2CA1 29 0F 00     ten15    and   #$0f
2425 2CA4 0A           tableX   asl   a                        ;multiply table entry by ten
2426 2CA5 85 24                 sta   tmpZP
2427 2CA7 0A                    asl   a
2428 2CA8 0A                    asl   a
2429 2CA9              ;       ;clc	            ;assume carry is clear
2430 2CA9 65 24                 adc   tmpZP
2431 2CAB A8                    tay                            ;and store in y
2432 2CAC 64 44                 stz   Btag
2433 2CAE 64 46                 stz   signB
2434 2CB0 64 4A                 stz   expnB+2
2435 2CB2 B9 E5 2C              lda   XTable+8,y
2436 2CB5 0A                    asl   a
2437 2CB6 26 46                 rol   signB
2438 2CB8 4A                    lsr   a
2439 2CB9 85 48                 sta   expnB
2440 2CBB A2 06 00              ldx   #$6
2441 2CBE B9 E3 2C              lda   XTable+6,y
2442 2CC1 85 72                 sta   FrctB
2443 2CC3 B9 E1 2C              lda   XTable+4,y
2444 2CC6 85 74                 sta   FrctB+2
2445 2CC8 B9 DF 2C              lda   XTable+2,y
2446 2CCB 85 76                 sta   FrctB+4
2447 2CCD B9 DD 2C              lda   XTable,y
2448 2CD0 85 78                 sta   FrctB+6
2449 2CD2 D0 06                 bne   z9s2
2450 2CD4 CA           z9s1     dex   
2451 2CD5 CA                    dex   
2452 2CD6 B5 72                 lda   FrctB,x
2453 2CD8 F0 FA                 beq   z9s1
2454 2CDA 86 4C        z9s2     stx   lgthB
2455 2CDC 60                    rts   
2456 2CDD                       EXPORT XTable 
2457 2CDD 00 00 00 00  XTable   DC W:0,$0,$0,$8000,$3FFF
2458 2CE7 00 00 00 00           DC W:0,$0,$0,$0A000,$4002
2459 2CF1 00 00 00 00           DC W:0,$0,$0,$0C800,$4005
2460 2CFB 00 00 00 00           DC W:0,$0,$0,$0FA00,$4008
2461 2D05 00 00 00 00           DC W:0,$0,$0,$9C40,$400C
2462 2D0F 00 00 00 00           DC W:0,$0,$0,$0C350,$400F
2463 2D19 00 00 00 00           DC W:0,$0,$0,$0F424,$4012
2464 2D23 00 00 00 00           DC W:0,$0,$8000,$9896,$4016
2465 2D2D 00 00 00 00           DC W:0,$0,$2000,$0BEBC,$4019
2466 2D37 00 00 00 00           DC W:0,$0,$2800,$0EE6B,$401C
2467 2D41 00 00 00 00           DC W:0,$0,$0F900,$9502,$4020
2468 2D4B 00 00 00 00           DC W:0,$0,$0B740,$0BA43,$4023
2469 2D55 00 00 00 00           DC W:0,$0,$0A510,$0E8D4,$4026
2470 2D5F 00 00 00 00           DC W:0,$0,$0E72A,$9184,$402A
2471 2D69 00 00 00 80           DC W:0,$8000,$20F4,$0B5E6,$402D
2472 2D73 00 00 00 A0           DC W:0,$0A000,$0A931,$0E35F,$4030
2473 2D7D 00 00 00 04           DC W:0,$0400,$0C9BF,$8E1B,$4034
2474 2D87                       EXPORT Rnd2Int 
2475 2D87              Rnd2Int                                 ;       
2476 2D87 64 26                 stz   tmpZP2                   ;least significant bit
2477 2D89 64 24                 stz   tmpZP                    ;round bit
2478 2D8B 38                    sec   
2479 2D8C A5 52                 lda   expnC                    ;find the bit location to the right of the
2480 2D8E E9 FF 3F              sbc   #$3fff                   ;lsb, with respect to msb of FrctC
2481 2D91 85 BE                 sta   expnX                    ;store it in expnX
2482 2D93 A5 54                 lda   expnC+2
2483 2D95 E5 38                 sbc   ZeroWord
2484 2D97 85 C0                 sta   expnX+2
2485 2D99 10 13                 bpl   z10s4                    ;least bit inside left side of FrctC
2486 2D9B A6 38                 ldx   ZeroWord                 ;set word location of first search
2487 2D9D A9 FF FF              lda   #$0ffff
2488 2DA0 C5 BE                 cmp   expnX
2489 2DA2 D0 5E                 bne   z10s10                   ;lsb miles to the left of msb of FrctC
2490 2DA4 C5 C0                 cmp   expnX+2
2491 2DA6 D0 5A                 bne   z10s10                   ;lsb to the left of msb of FrctC
2492 2DA8 A9 00 80              lda   #$8000                   ;round bit just left of FrctC
2493 2DAB D0 3C                 bne   z10s8                    ;check round bit, branch always !!!!!!!
2494 2DAD 60           z10s3    rts   
2495 2DAE A5 BE        z10s4    lda   expnX                    ;make bit mask
2496 2DB0 29 0F 00              and   #$0f
2497 2DB3 AA                    tax   
2498 2DB4 38                    sec   
2499 2DB5 A5 38                 lda   ZeroWord
2500 2DB7 6A           z10s5    ror   a
2501 2DB8 CA                    dex   
2502 2DB9 10 FC                 bpl   z10s5
2503 2DBB 85 2A                 sta   tmpZP4
2504 2DBD A8                    tay                            ;save mask in y
2505 2DBE 46 C0                 lsr   ExpnX+2                  ;calculate word location of lsb
2506 2DC0 66 BE                 ror   ExpnX
2507 2DC2 46 C0                 lsr   ExpnX+2
2508 2DC4 66 BE                 ror   ExpnX
2509 2DC6 46 C0                 lsr   ExpnX+2
2510 2DC8 66 BE                 ror   ExpnX
2511 2DCA 66 BE                 ror   ExpnX
2512 2DCC 06 BE                 asl   ExpnX
2513 2DCE A6 C0                 ldx   ExpnX+2
2514 2DD0 D0 DB                 bne   z10s3                    ;binary point is miles to the right
2515 2DD2 A6 BE                 ldx   ExpnX
2516 2DD4 E4 56                 cpx   lgthC                    ;ExpnX - lgthC
2517 2DD6 F0 02                 beq   z10s7
2518 2DD8 B0 D3                 bcs   z10s3                    ;decimal point beyond FrctC
2519 2DDA 35 8C        z10s7    and   FrctC,x
2520 2DDC 85 26                 sta   tmpZP2                   ;save lsb
2521 2DDE 98                    tya   
2522 2DDF 4A                    lsr   a
2523 2DE0 D0 07                 bne   z10s8                    ;not crossing word boundry
2524 2DE2 6A                    ror   a                        ;crossing a word boundry, take special action
2525 2DE3 E4 56                 cpx   lgthC                    ;x - lgthC
2526 2DE5 10 C6                 bpl   z10s3                    ;no Round or Sticky bits
2527 2DE7 E8                    inx   
2528 2DE8 E8                    inx   
2529 2DE9 A8           z10s8    tay                            ;check the round bit
2530 2DEA 35 8C                 and   frctC,x
2531 2DEC 85 24                 sta   tmpZP                    ;save round bit
2532 2DEE 55 8C                 eor   frctC,x                  ;clear round bit
2533 2DF0 95 8C                 sta   frctC,x
2534 2DF2 98                    tya                            ;now deal with the sticky bit
2535 2DF3 A4 38                 ldy   ZeroWord                 ;initialize sticky bit container
2536 2DF5 3A                    dec   a
2537 2DF6 F0 04                 beq   z10s9                    ;crossing a word boundry
2538 2DF8 35 8C                 and   frctC,x
2539 2DFA D0 0A                 bne   z10s11                   ;sticky bit found
2540 2DFC E4 56        z10s9    cpx   lgthC
2541 2DFE 10 0C                 bpl   done                     ;x >= lgthC, no sticky bits found
2542 2E00 E8                    inx   
2543 2E01 E8                    inx   
2544 2E02 B5 8C        z10s10   lda   frctC,x
2545 2E04 F0 F6                 beq   z10s9                    ;no sticky bit in this word, ck the next one
2546 2E06 A8           z10s11   tay                            ;save sticky bits in y
2547 2E07 55 8C                 eor   frctC,x                  ;clear sticky bits
2548 2E09 95 8C                 sta   frctC,x
2549 2E0B 98                    tya                            ;get sticky bits
2550 2E0C 05 24        done     ora   tmpZP                    ;or with round bit
2551 2E0E F0 4B                 beq   finRTI                   ;no extra bits
2552 2E10 A5 1E                 lda   tmpflgs
2553 2E12 09 10 00              ora   #inexcp
2554 2E15 85 1E                 sta   tmpflgs
2555 2E17 86 56                 stx   lgthC
2556 2E19 A9 00 C0              lda   #$0c000                  ;mask in rounding direction
2557 2E1C 24 1C                 bit   EnvWrd
2558 2E1E F0 10                 beq   RndNr
2559 2E20 30 06                 bmi   z11s9                    ;either downward or toward zero
2560 2E22 A5 50                 lda   signC                    ;round upward
2561 2E24 F0 13                 beq   RndUp                    ;sign is positive
2562 2E26 D0 43                 bne   NoRndUp                  ;no rounding up (in magnitude)
2563 2E28 70 41        z11s9    bvs   NoRndUp                  ;toward zero
2564 2E2A A5 50                 lda   signC                    ;round downward
2565 2E2C D0 0B                 bne   RndUp                    ;sign is negative
2566 2E2E F0 3B                 beq   NoRndUp                  ;no rounding up (in magnitude)
2567 2E30 A5 24        RndNr    lda   tmpZp                    ;get round bit
2568 2E32 F0 37                 beq   NoRndUp                  ;no round bit, dump trailing zero words
2569 2E34 98                    tya                            ;get sticky bits
2570 2E35 05 26                 ora   tmpZP2                   ;or lsb & sticky bit
2571 2E37 F0 32                 beq   NoRndUp                  ;no rounding up (in magnitude)
2572 2E39              ;                       environment word is rr-xdoui RR-XDOUI
2573 2E39              ;                                           rd xcpns rp halts
2574 2E39              ;               0 to nearest, 1 upward, 2 downward, 3 toward zero
2575 2E39 A6 C0        RndUp    ldx   ExpnX+2
2576 2E3B 30 1F                 bmi   rtnOne                   ;lsb to the left of FrctC, return 1
2577 2E3D A6 BE                 ldx   ExpnX                    ;get word location of round bit
2578 2E3F 18                    clc   
2579 2E40 A5 2A                 lda   tmpZP4                   ;get location of round bit
2580 2E42 75 8C                 adc   FrctC,x
2581 2E44 95 8C                 sta   FrctC,x
2582 2E46 90 13                 bcc   finRTI
2583 2E48 B0 04                 bcs   RUp2
2584 2E4A F6 8C        RUpLoop  inc   FrctC,x
2585 2E4C D0 0D                 bne   finRTI
2586 2E4E CA           RUp2     dex   
2587 2E4F CA                    dex   
2588 2E50 10 F8                 bpl   RUpLoop
2589 2E52 38                    sec   
2590 2E53 66 8C                 ror   FrctC                    ;right shift signicand
2591 2E55 E6 52                 inc   expnC                    ;adjust the exponent
2592 2E57 D0 02                 bne   finRTI
2593 2E59 E6 54                 inc   expnC+2
2594 2E5B 60           finRTI   rts   
2595 2E5C 64 54        rtnOne   stz   expnC+2
2596 2E5E A9 FF 3F              lda   #$3fff
2597 2E61 85 52                 sta   expnC
2598 2E63 64 56                 stz   lgthC
2599 2E65 A9 00 80              lda   #$8000
2600 2E68 85 8C                 sta   FrctC
2601 2E6A 60                    rts                            ;tag and sign are OK
2602 2E6B A6 C0        NoRndUp  ldx   ExpnX+2
2603 2E6D 10 EC                 bpl   finRTI                   ;lsb to the left of FrctC, return 0
2604 2E6F 4C 31 1F              jmp   rtnZero
2605 2E72                       ENDP 
2606 2E72              ;          copy sane/d2b
2607 2E72              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
2608 2E72              ;; File:  D2B
2609 2E72              ;; Description: Decimal --> Binary for ORCA SANE 65816 floating point engine
2610 2E72              ;; Status: ROM 2.0 and them some.
2611 2E72              ;;
2612 2E72              ;; Written by Kenton Hanson, Apple Numerics Group, 16 May 1986
2613 2E72              ;;
2614 2E72              ;; Modification History
2615 2E72              ;;
2616 2E72              ;;    23 mar 87       Kenton Hanson
2617 2E72              ;;
2618 2E72              ;;       Sticky bit word error in multiply corrected.
2619 2E72              ;; 
2620 2E72              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
2621 2E72                       EXPORT D2B 
2622 2E72              D2B      PROC 
2623 2E72              ;       ;ldx    fence           ;done in 'fp816'
2624 2E72 86 30                 stx   fence2                   ;set destination format
2625 2E74 68 85 0C 68           pop   Crgstr                   ;pointer to destination
2626 2E7A 68 85 14 68           pop   Argstr                   ;pointer to decimal record
2627 2E80 AD D8 1C              lda   rtnA
2628 2E83 48                    pha                            ;push 'rthArth' as return address
2629 2E84 64 46                 stz   signB
2630 2E86 64 50                 stz   signC
2631 2E88 A4 38                 ldy   ZeroWord
2632 2E8A B7 14                 lda   [Argstr],y
2633 2E8C F0 04                 beq   z1s0
2634 2E8E E6 46                 inc   signB
2635 2E90 E6 50                 inc   signC
2636 2E92 A0 04 00     z1s0     ldy   #BgnSgDg                 ;relative location of SigDig in Decimal
2637 2E95 B7 14                 lda   [Argstr],y
2638 2E97 29 FF 00              and   #$0ff
2639 2E9A F0 1D                 beq   z1s99                    ;NULL string, return zero
2640 2E9C 85 A6                 sta   len
2641 2E9E C8                    iny   
2642 2E9F 84 24                 sty   tmpZP                    ;initialize string pointer
2643 2EA1 C9 1D 00              cmp   #SigDigLn+1
2644 2EA4 90 04                 bcc   z1s1                     ;a <= SigDigLn
2645 2EA6 A9 1C 00              lda   #SigDigLn
2646 2EA9 18                    clc   
2647 2EAA 69 04 00     z1s1     adc   #BgnSgDg
2648 2EAD 85 26                 sta   tmpZP2                   ;initialize end location of string in record
2649 2EAF B7 14                 lda   [Argstr],y
2650 2EB1 29 FF 00              and   #$0ff
2651 2EB4 C9 30 00              cmp   #$30                     ;ASCII zero
2652 2EB7 D0 03                 bne   z1s2
2653 2EB9 4C 31 1F     z1s99    jmp   rtnZero                  ;jsr & rts
2654 2EBC 29 DF 00     z1s2     and   #$0df
2655 2EBF C9 49 00              cmp   #$49                     ;ASCII 'i' or 'I'
2656 2EC2 D0 03                 bne   z1s22
2657 2EC4 4C 36 1F              jmp   RtnInf
2658 2EC7 C9 4E 00     z1s22    cmp   #$4e                     ;ASCII 'n' or 'N'
2659 2ECA D0 71                 bne   gtdgts
2660 2ECC A9 FD FF              lda   #NaNtag
2661 2ECF 85 4E                 sta   Ctag
2662 2ED1 64 56                 stz   lgthC                    ;initialize FrctC
2663 2ED3 64 8C                 stz   FrctC
2664 2ED5 A6 56                 ldx   lgthC
2665 2ED7 E6 26                 inc   tmpZP2
2666 2ED9 64 28                 stz   tmpZP3                   ;flag for next word
2667 2EDB C8           z1s3     iny   
2668 2EDC C4 26                 cpy   tmpZP2
2669 2EDE B0 37                 bcs   z1s5                     ;tmpZP >= tmpZP2
2670 2EE0 E2 30                 sep   #$30
2671 2EE2 B7 14                 lda   [Argstr],y
2672 2EE4 C2 30                 rep   #$30
2673 2EE6 29 FF 00              and   #$00ff
2674 2EE9 C9 41 00              cmp   #$41                     ;'A'
2675 2EEC 90 03                 bcc   z1s4                     ;a < 'A'
2676 2EEE 69 08 00              adc   #$8                      ;carry was set, i.e., a := a + 9
2677 2EF1 29 0F 00     z1s4     and   #$0f                     ;get low order nibble
2678 2EF4 C0 0A 00              cpy   #BgnSgDg+6
2679 2EF7 F0 14                 beq   The6th
2680 2EF9 06 28                 asl   tmpZP3
2681 2EFB B0 10                 bcs   The6th
2682 2EFD 16 8C        MoreNaN  asl   FrctC,x
2683 2EFF 16 8C                 asl   FrctC,x
2684 2F01 16 8C                 asl   FrctC,x
2685 2F03 16 8C                 asl   FrctC,x
2686 2F05 66 28                 ror   tmpZP3                   ;next word flag
2687 2F07 15 8C                 ora   FrctC,x
2688 2F09 95 8C                 sta   FrctC,x
2689 2F0B 80 CE                 bra   z1s3                     ;always true
2690 2F0D E8           The6th   inx   
2691 2F0E E8                    inx   
2692 2F0F 86 56                 stx   lgthC
2693 2F11 74 8C                 stz   FrctC,x
2694 2F13 F6 8C                 inc   FrctC,x
2695 2F15 80 E6                 bra   MoreNaN
2696 2F17 8A           z1s5     txa   
2697 2F18 F0 08                 beq   z1s7                     ;1st word, don't left justify
2698 2F1A 24 28                 bit   tmpZP3
2699 2F1C 30 04                 bmi   z1s7
2700 2F1E 16 8C        z1s6     asl   FrctC,x
2701 2F20 90 FC                 bcc   z1s6
2702 2F22 A9 00 40     z1s7     lda   #$4000                   ;bit for signaling NaN
2703 2F25 24 8C                 bit   FrctC                    ; *** 21 March 1985 ***
2704 2F27 D0 05                 bne   z1s8                     ;not a signaling NaN
2705 2F29 A5 8C                 lda   FrctC
2706 2F2B 4C 43 1F              jmp   InvNaN2                  ;jsr & rts
2707 2F2E A5 8C        z1s8     lda   FrctC
2708 2F30 29 FF 00              and   #$0ff
2709 2F33 D0 07                 bne   z1s9                     ;Non zero NaN code found
2710 2F35 A9 15 40              lda   #NaNZero
2711 2F38 05 8C                 ora   FrctC
2712 2F3A 85 8C                 sta   FrctC
2713 2F3C 60           z1s9     rts   
2714 2F3D 64 4C        gtdgts   stz   lgthB                    ;initialize FrctB
2715 2F3F 64 72                 stz   FrctB
2716 2F41 64 44                 stz   Btag                     ;intialize tag
2717 2F43 A0 02 00              ldy   #$2
2718 2F46 B7 14                 lda   [Argstr],y
2719 2F48 85 AA                 sta   iscale                   ;get exponent into iscale
2720 2F4A 10 5C                 bpl   z2s12                    ;do not need to strip trailing ASCII zeros
2721 2F4C A4 26        z2s3     ldy   tmpZP2
2722 2F4E E2 30                 sep   #$30
2723 2F50 B7 14                 lda   [Argstr],y
2724 2F52 C2 30                 rep   #$30
2725 2F54 29 0F 00              and   #$0f                     ;change ASCII digit to binary
2726 2F57 D0 4F                 bne   z2s12                    ;no more trailing zeros
2727 2F59 C6 26                 dec   tmpZP2
2728 2F5B E6 AA                 inc   iscale
2729 2F5D 30 ED                 bmi   z2s3                     ;iscale still < 0
2730 2F5F 10 47                 bpl   z2s12
2731 2F61 C6 AA        z2s4     dec   iscale                   ;iscale := iscale - 1
2732 2F63 A5 72        z2s5     lda   FrctB
2733 2F65 29 00 E0              and   #$0e000
2734 2F68 F0 05                 beq   z2s6                     ;no byte shift necessary
2735 2F6A 20 FC 2F              jsr   rtWord
2736 2F6D 64 72                 stz   FrctB
2737 2F6F A6 4C        z2s6     ldx   lgthB                    ;multiply by 10
2738 2F71 18                    clc   
2739 2F72 B5 72        z2s7     lda   FrctB,x
2740 2F74 2A                    rol   a
2741 2F75 95 58                 sta   FrctA,x
2742 2F77 95 72                 sta   FrctB,x
2743 2F79 CA                    dex   
2744 2F7A CA                    dex   
2745 2F7B 10 F5                 bpl   z2s7
2746 2F7D A0 02 00              ldy   #$2
2747 2F80 A6 4C        z2s8     ldx   lgthB
2748 2F82 36 72        z2s9     rol   FrctB,x
2749 2F84 CA                    dex   
2750 2F85 CA                    dex   
2751 2F86 10 FA                 bpl   z2s9
2752 2F88 88                    dey   
2753 2F89 D0 F5                 bne   z2s8
2754 2F8B A6 4C                 ldx   lgthB
2755 2F8D B5 58        z2s10    lda   FrctA,x
2756 2F8F 75 72                 adc   FrctB,x
2757 2F91 95 72                 sta   FrctB,x
2758 2F93 CA                    dex   
2759 2F94 CA                    dex   
2760 2F95 10 F6                 bpl   z2s10
2761 2F97 90 03                 bcc   z2s11
2762 2F99 20 FC 2F              jsr   rtWord
2763 2F9C A4 24        z2s11    ldy   tmpZP
2764 2F9E C4 26                 cpy   tmpZP2
2765 2FA0 E6 24                 inc   tmpZP
2766 2FA2 90 04                 bcc   z2s12                    ;tmpZP <= tmpZP2
2767 2FA4 A4 24                 ldy   tmpZP
2768 2FA6 B0 1D                 bcs   z2s14                    ;always true
2769 2FA8 A4 24        z2s12    ldy   tmpZP
2770 2FAA E2 30                 sep   #$30
2771 2FAC B7 14                 lda   [Argstr],y
2772 2FAE C2 30                 rep   #$30
2773 2FB0 29 0F 00              and   #$0f                     ;change ASCII digit to binary
2774 2FB3 A6 4C                 ldx   lgthB
2775 2FB5 18                    clc   
2776 2FB6 75 72        z2s13    adc   FrctB,x
2777 2FB8 95 72                 sta   FrctB,x
2778 2FBA 90 09                 bcc   z2s14
2779 2FBC A5 38                 lda   ZeroWord
2780 2FBE CA                    dex   
2781 2FBF CA                    dex   
2782 2FC0 10 F4                 bpl   z2s13
2783 2FC2 20 FC 2F              jsr   rtWord
2784 2FC5 C4 26        z2s14    cpy   tmpZP2
2785 2FC7 90 9A                 bcc   z2s5                     ;y < tmpZP2
2786 2FC9 A5 AA                 lda   iscale
2787 2FCB F0 07                 beq   z2s15                    ;iscale = 0
2788 2FCD 30 05                 bmi   z2s15                    ;iscale < 0, appending zeros does no good
2789 2FCF C0 20 00              cpy   #BgnSgDg+SigDigLn
2790 2FD2 90 8D                 bcc   z2s4                     ;y < SigDigLn, append zero
2791 2FD4 A5 72        z2s15    lda   FrctB
2792 2FD6 D0 03                 bne   z2s17
2793 2FD8 4C 31 1F     z2s16    jmp   rtnZero                  ;jsr & rts
2794 2FDB A5 4C        z2s17    lda   lgthB
2795 2FDD 0A                    asl   a                        ;multiply by 8
2796 2FDE 0A                    asl   a
2797 2FDF 0A                    asl   a
2798 2FE0              ;      ;clc
2799 2FE0 69 0E 40              adc   #$400e                   ;add bias (3fff) + 16. - 1
2800 2FE3 85 48                 sta   expnB
2801 2FE5 64 4A                 stz   expnB+2
2802 2FE7 24 72                 bit   FrctB
2803 2FE9 30 03                 bmi   z2s18                    ;already normalized
2804 2FEB 20 03 22              jsr   BgnNrmB
2805 2FEE 20 BB 2A     z2s18    jsr   BtoE
2806 2FF1 A5 AA                 lda   iscale
2807 2FF3 85 24                 sta   tmpZP                    ;save original iscale
2808 2FF5 49 FF FF              eor   #$0ffff
2809 2FF8 1A                    inc   a                        ;-iscale
2810 2FF9 4C B3 2B              jmp   ScaleIt                  ;jsr, rts
2811 2FFC A6 4C        rtWord   ldx   lgthB
2812 2FFE E0 1A 00              cpx   #FrctC-FrctB
2813 3001 B0 12                 bcs   z3s2                     ;cnm >= 13, don't overwrite memory
2814 3003 E6 4C                 inc   lgthB                    ;increase length of lgthB
2815 3005 E6 4C                 inc   lgthB
2816 3007 B5 72        z3s1     lda   FrctB,x
2817 3009 95 74                 sta   FrctB+2,x
2818 300B CA                    dex   
2819 300C CA                    dex   
2820 300D 10 F8                 bpl   z3s1
2821 300F A9 01 00              lda   #$1
2822 3012 85 72                 sta   FrctB
2823 3014 60                    rts   
2824 3015 A9 11 40     z3s2     lda   #NanAscB                 ;Invalid dec -> bin conversion: syntax
2825 3018 68                    pla                            ;to prevent returning to digit gathering code
2826 3019 4C 41 1F              jmp   invNaN                   ;rts
2827 301C                       EXPORT Mul 
2828 301C              Mul                                     ;       
2829 301C A6 3A                 ldx   Atag
2830 301E 30 09                 bmi   z4s3
2831 3020 A4 44                 ldy   Btag
2832 3022 10 1C                 bpl   BgnMlt                   ;no special cases
2833 3024 C8                    iny   
2834 3025 F0 0A                 beq   z4s4                     ;B is zero and A is a number, return zero
2835 3027 30 0E                 bmi   z4s6                     ;B is infinity and A is a number, rtn infinity
2836 3029 A4 44        z4s3     ldy   Btag
2837 302B E8                    inx   
2838 302C 30 06                 bmi   z4s5                     ;A is infinity
2839 302E C8                    iny                            ;A is zero
2840 302F 30 09                 bmi   z4s7                     ;A is zero and B is infinity, return invalid
2841 3031              ;                                       ;A is zero and B is not infinity, return zero
2842 3031 4C 31 1F     z4s4     jmp   rtnZero
2843 3034 C8           z4s5     iny   
2844 3035 F0 03                 beq   z4s7                     ;A is infinity and B is zero, return invalid
2845 3037              ;                                       ;A is infinity and B is non zero, rtn Infinity
2846 3037 4C 36 1F     z4s6     jmp   rtnInf
2847 303A A9 08 40     z4s7     lda   #NanMlt
2848 303D 4C 41 1F              jmp   InvNan
2849 3040                       EXPORT BgnMlt 
2850 3040              BgnMlt                                  ; 
2851 3040              ;--------------------------------------------------
2852 3040              ; Added 23 Mar 87 to fix problem with multiplies
2853 3040              ; of numbers with different formats.  Result was
2854 3040              ; not coming back in extended.
2855 3040              ; 
2856 3040 A6 2E                 ldx   Fence
2857 3042 BC 81 1B              ldy   stkBtWd,x
2858 3045 84 34                 sty   SBWord
2859 3047              ; 
2860 3047              ; End of addition 
2861 3047              ;-------------------------------------------------- 
2862 3047 A6 42                 ldx   lgthA
2863 3049 86 56                 stx   lgthC
2864 304B 86 26                 stx   tmpZP2
2865 304D 46 26                 lsr   tmpZP2                   ;current word count for FrctC
2866 304F 74 8C        z5s2     stz   FrctC,X                  ;initialize C
2867 3051 CA                    dex   
2868 3052 CA                    dex   
2869 3053 10 FA                 bpl   z5s2
2870 3055 A6 4C        z5s3     ldx   lgthB
2871 3057 B5 72                 lda   frctB,x
2872 3059 85 24                 sta   tmpZP
2873 305B A0 0F 00              ldy   #$0f
2874 305E 46 24        z5s4     lsr   tmpZP
2875 3060 90 0D                 bcc   z5s6
2876 3062 18                    clc   
2877 3063 A6 42                 ldx   lgthA
2878 3065 B5 8C        z5s5     lda   FrctC,x
2879 3067 75 58                 adc   FrctA,x
2880 3069 95 8C                 sta   FrctC,x
2881 306B CA                    dex   
2882 306C CA                    dex   
2883 306D 10 F6                 bpl   z5s5
2884 306F A5 26        z5s6     lda   tmpZP2                   ;get current word count for FrctC
2885 3071 A6 38                 ldx   ZeroWord
2886 3073 76 8C        z5s7     ror   Frctc,x                  ;Note, carry is correct for first shift
2887 3075 E8                    inx   
2888 3076 E8                    inx   
2889 3077 3A                    dec   a
2890 3078 10 F9                 bpl   z5s7
2891 307A 90 18                 bcc   z5s10                    ;no carry propagation
2892 307C A6 56                 ldx   lgthC
2893 307E E4 34                 cpx   SBWord                   ;lgthC - SBWord
2894 3080 90 07                 bcc   z5s8                     ;lgthC < SBWord
2895 3082 B5 8C                 lda   FrctC,x
2896 3084 09 01 00              ora   #$1                      ;or carry out, into last bit of FrctC,x
2897 3087 D0 09                 bne   z5s9                     ;always true
2898 3089 E8           z5s8     inx                            ;add new word with a leading bit set
2899 308A E8                    inx   
2900 308B 86 56                 stx   lgthC
2901 308D E6 26                 inc   tmpZP2                   ;update word length
2902 308F A9 00 80              lda   #$8000
2903 3092 95 8C        z5s9     sta   FrctC,x
2904 3094 88           z5s10    dey   
2905 3095 10 C7                 bpl   z5s4
2906 3097 C6 4C                 dec   lgthB
2907 3099 C6 4C                 dec   lgthB
2908 309B 10 B8                 bpl   z5s3
2909 309D 18                    clc   
2910 309E A5 3E                 lda   expnA
2911 30A0 65 48                 adc   expnB
2912 30A2 85 52                 sta   expnC
2913 30A4 A5 40                 lda   expnA+2
2914 30A6 65 4A                 adc   expnB+2
2915 30A8 85 54                 sta   expnC+2
2916 30AA A5 8C                 lda   FrctC
2917 30AC 0A                    asl   a
2918 30AD B0 09                 bcs   z5s13                    ;leading bit set, no left shift necessary
2919 30AF A6 56                 ldx   lgthC
2920 30B1 18                    clc   
2921 30B2 36 8C        z5s12    rol   FrctC,x
2922 30B4 CA                    dex   
2923 30B5 CA                    dex   
2924 30B6 10 FA                 bpl   z5s12
2925 30B8 A5 52        z5s13    lda   expnC                    ;adjust exponent
2926 30BA E9 FE 3F              sbc   #$3ffe
2927 30BD 85 52                 sta   expnC
2928 30BF A5 54                 lda   expnC+2
2929 30C1 E5 38                 sbc   ZeroWord
2930 30C3 85 54                 sta   expnC+2
2931 30C5 A6 56        z5s15    ldx   lgthC                    ;strip trailing zero word loop
2932 30C7 B5 8C                 lda   FrctC,x
2933 30C9 D0 06                 bne   z5s20
2934 30CB C6 56                 dec   lgthC
2935 30CD C6 56                 dec   lgthC
2936 30CF 10 F4                 bpl   z5s15
2937 30D1 60           z5s20    rts   
2938 30D2                       EXPORT DnrmC 
2939 30D2              DnrmC                                   ;       
2940 30D2 A6 2E                 ldx   fence
2941 30D4 A5 C0                 lda   expnX+2                  ;contains hi word of number of right shifts
2942 30D6 D0 0A                 bne   z6s2                     ;do max shift
2943 30D8 A5 BE                 lda   expnX                    ;expnX contains low word of # of right shifts
2944 30DA D0 01                 bne   z6s1
2945 30DC 60                    rts                            ;no shifting
2946 30DD DD AD 1B     z6s1     cmp   MaxShft,x
2947 30E0 90 05                 bcc   z6s3                     ;a < MaxShft,x
2948 30E2 BD AD 1B     z6s2     lda   MaxShft,x                ;stuff maximum shift into expnX
2949 30E5 85 BE                 sta   expnX
2950 30E7 BC 81 1B     z6s3     ldy   StkBtWd,x                ;; tmpZP2 := max (lgthC, MaxShft,x)
2951 30EA C4 56                 cpy   lgthC                    ;StkBtWd,x - lgthC
2952 30EC 10 02                 bpl   z6s4
2953 30EE A4 56                 ldy   lgthC
2954 30F0 84 26        z6s4     sty   tmpZp2                   ;maximum length, i.e., max (lgthC, MaxShft,x)
2955 30F2 64 28        BitShft  stz   tmpZP3                   ;left storage word for bit shift
2956 30F4 A5 BE                 lda   expnX                    ;number of right shifts
2957 30F6 29 0F 00              and   #$0f
2958 30F9 F0 48                 beq   WrdShft                  ;no bit shift
2959 30FB C9 09 00              cmp   #$9
2960 30FE 90 16                 bcc   z7s3                     ;a < 9
2961 3100 A6 56        z7s1     ldx   lgthC
2962 3102 18                    clc   
2963 3103 36 8C        z7s2     rol   FrctC,x
2964 3105 CA                    dex   
2965 3106 CA                    dex   
2966 3107 10 FA                 bpl   z7s2
2967 3109 26 28                 rol   tmpZP3
2968 310B E6 BE                 inc   expnX
2969 310D A5 BE                 lda   expnX
2970 310F 29 0F 00              and   #$0f
2971 3112 D0 EC                 bne   z7s1
2972 3114 F0 2D                 beq   WrdShft
2973 3116 A6 38        z7s3     ldx   ZeroWord
2974 3118 18                    clc   
2975 3119 76 8C        z7s4     ror   FrctC,x
2976 311B 8A                    txa   
2977 311C 45 56                 eor   lgthC
2978 311E F0 04                 beq   z7s5
2979 3120 E8                    inx   
2980 3121 E8                    inx   
2981 3122 D0 F5                 bne   z7s4                     ;branch always  branch always  branch always
2982 3124 90 14        z7s5     bcc   z7s9
2983 3126 E4 26                 cpx   tmpZP2
2984 3128 10 09                 bpl   z7s7                     ;x >= tmpZP2 (i.e., StkBtWd,x)
2985 312A E8                    inx   
2986 312B E8                    inx   
2987 312C 86 56                 stx   lgthC
2988 312E A9 00 80              lda   #$8000
2989 3131 D0 05                 bne   z7s8                     ;branch always  branch always  branch always
2990 3133 B5 8C        z7s7     lda   FrctC,x
2991 3135 09 01 00              ora   #$1                      ;or in sticky bit
2992 3138 95 8C        z7s8     sta   FrctC,x
2993 313A C6 BE        z7s9     dec   expnX
2994 313C A5 BE                 lda   expnX
2995 313E 29 0F 00              and   #$0f
2996 3141 D0 D3                 bne   z7s3
2997 3143 64 2A        WrdShft  stz   tmpZP4                   ;bucket for sticky words
2998 3145 A5 BE                 lda   expnX                    ;number of bits to be shifted
2999 3147 4A                    lsr   a
3000 3148 4A                    lsr   a
3001 3149 4A                    lsr   a
3002 314A 4A                    lsr   a
3003 314B F0 24                 beq   ckTail                   ;no word shift
3004 314D A8                    tay                            ;number of word shifts
3005 314E A6 56        z8s3     ldx   lgthC
3006 3150 E4 26                 cpx   TmpZP2                   ;x - MaxlgthC
3007 3152 30 08                 bmi   z8s4                     ;x < MaxlgthC
3008 3154 B5 8C                 lda   FrctC,x
3009 3156 F0 0C                 beq   z8s6
3010 3158 85 2A                 sta   tmpZP4                   ;sticky word found, save it
3011 315A D0 08                 bne   z8s6
3012 315C E6 56        z8s4     inc   lgthC
3013 315E E6 56                 inc   lgthC
3014 3160 B5 8C        z8s5     lda   FrctC,x                  ;right shift one word loop
3015 3162 95 8E                 sta   FrctC+2,x
3016 3164 CA           z8s6     dex   
3017 3165 CA                    dex   
3018 3166 10 F8                 bpl   z8s5
3019 3168 A5 28                 lda   tmpZP3                   ;on first pass use original value
3020 316A 85 8C                 sta   FrctC
3021 316C 64 28                 stz   tmpZP3                   ;thereafter, fill from the left with zero words
3022 316E 88                    dey   
3023 316F D0 DD                 bne   z8s3
3024 3171 A5 2A        ckTail   lda   tmpZP4
3025 3173 F0 0B                 beq   z9s7                     ;nothing in sticky word bucket
3026 3175 A6 56                 ldx   lgthC
3027 3177 B5 8C                 lda   FrctC,x
3028 3179 09 01 00              ora   #$1                      ;insert sticky bit
3029 317C 95 8C                 sta   FrctC,x
3030 317E D0 0C                 bne   z9s8                     ;branch always
3031 3180 A6 56        z9s7     ldx   lgthC
3032 3182 B5 8C                 lda   FrctC,x
3033 3184 D0 06                 bne   z9s8
3034 3186 C6 56                 dec   lgthC
3035 3188 C6 56                 dec   lgthC
3036 318A 10 F4                 bpl   z9s7
3037 318C 60           z9s8     rts   
3038 318D                       ENDP 
3039 318D              ;          copy sane/dcstr
3040 318D                       EXPORT DecStr 
3041 318D              DecStr   PROC 
3042 318D 22 64 00 E1           jsl   IncBusyFlg
3043 3191 0B                    phd                            ; put direct reg on stack
3044 3192 5B                    tcd                            ; set direct reg
3045 3193 68                    pla                            ; save orig direct on zp
3046 3194 85 06                 sta   OrigDirect
3047 3196 8B                    phb                            ; save original data bank register
3048 3197 8B                    phb   
3049 3198 68                    pla   
3050 3199 85 08                 sta   OrigBank                 ; on zero page
3051 319B 4B                    phk                            ; set data bank register
3052 319C AB                    plb                            ; this bank
3053 319D 68                    pla   
3054 319E 85 00                 sta   ZPRtn
3055 31A0 68                    pla   
3056 31A1 85 02                 sta   ZPRtn+2
3057 31A3 68                    pla   
3058 31A4 85 04                 sta   ZPRtn+4
3059 31A6              FOPSTR2DEC equ   0                      ; Pascal string to decimal record
3060 31A6              FOCSTR2DEC equ   2                      ; C string to decimal record
3061 31A6              FODEC2STR equ   1                       ; decimal record to string
3062 31A6              ;      ;.proc   DecStr
3063 31A6              ;      ;.ref    Str2Dec,Dec2Str,CStr2Dec
3064 31A6 FA                    plx                            ;put opcode into 'x'
3065 31A7 AD DA 1C              lda   rtnB                     ;address of XitFP
3066 31AA 48                    pha   
3067 31AB E0 01 00              cpx   #FODEC2STR               ;opcode - #FODEC2STR
3068 31AE 10 03                 bpl   z1s3
3069 31B0 4C 68 34              jmp   Str2Dec
3070 31B3 D0 03        z1s3     bne   z1s4
3071 31B5 4C BB 31              jmp   Dec2Str
3072 31B8 4C 62 34     z1s4     jmp   CStr2Dec
3073 31BB                       ENDP 
3074 31BB              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3075 31BB              ;; File: NewD2S.TEXT
3076 31BB              ;; 6502 number formatter -- implements Pascal Dec2Str
3077 31BB              ;; Status: ALPHA
3078 31BB              ;; Copyright Apple Computer, Inc. 1985
3079 31BB              ;;
3080 31BB              ;; Written by Kenton Hanson, Apple Numerics Group, 8 March 85
3081 31BB              ;; 
3082 31BB              ;; 8 May 86, KLH modified for Cortland Orca assembler
3083 31BB              ;;      ___________________________________________________________
3084 31BB              ;;
3085 31BB              ;; Description: This code is intended to be position independent
3086 31BB              ;;
3087 31BB              ;;
3088 31BB              ;; Const
3089 31BB              ;;    DECSTRLEN = 80;
3090 31BB              ;;    SigDigLen = 28;
3091 31BB              ;; type
3092 31BB              ;;    DecStr   = string [DECSTRLEN];
3093 31BB              ;;    Decimal  = record
3094 31BB              ;;                  sgn : 0..1;
3095 31BB              ;;                  exp : integer;
3096 31BB              ;;                  sig : string [SigDigLen]
3097 31BB              ;;               end;
3098 31BB              ;;    DecForm = record
3099 31BB              ;;                  style  : (FLOATDecimal, FIXEDDecimal);
3100 31BB              ;;                  digits : integer
3101 31BB              ;;               end;
3102 31BB              ;;
3103 31BB              ;;
3104 31BB              ;; Procedure Dec2Str (f : DecForm; d : decimal; var y : DecStr) ; external;
3105 31BB              ;;
3106 31BB              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3107 31BB                       EXPORT Dec2Str 
3108 31BB              Dec2Str  PROC 
3109 31BB              wmax     equ   80
3110 31BB              wmaxP1   equ   wmax+1
3111 31BB              wmaxP4   equ   wmax+4
3112 31BB              temp     equ   128
3113 31BB              fstyle   equ   temp
3114 31BB              fdgts    equ   temp+1
3115 31BB              dst      equ   temp+2
3116 31BB              src      equ   temp+6
3117 31BB              BCD      equ   temp+6                   ; holds BCD intermediate result (3 bytes)
3118 31BB              DecFrm   equ   temp+10
3119 31BB              sgn      equ   DecFrm
3120 31BB              MinDig   equ   temp+11                  ; minus Minimum digits for NaN or Exponent
3121 31BB              exp      equ   DecFrm+2
3122 31BB              dsig     equ   DecFrm+4
3123 31BB              frstdig  equ   DecFrm+5
3124 31BB A2 00 00              ldx   #$00
3125 31BE 68           z20s0    pla                            ; pull return and arguments from stack
3126 31BF 95 80                 sta   temp,x
3127 31C1 E8                    inx   
3128 31C2 E8                    inx   
3129 31C3 E0 0E 00              cpx   #$0e
3130 31C6 D0 F6                 bne   z20s0
3131 31C8 A5 80                 lda   temp                     ; push return address back onto stack
3132 31CA 48                    pha   
3133 31CB                       longa off
3134 31CB                       longi off
3135 31CB E2 30                 sep   #$30
3136 31CD A0 00                 ldy   #$00
3137 31CF B7 8A                 lda   [DecFrm],y               ; get DecForm into memory
3138 31D1 85 80                 sta   fstyle
3139 31D3 A0 02                 ldy   #$02
3140 31D5 B7 8A                 lda   [DecFrm],y
3141 31D7 85 81                 sta   fdgts
3142 31D9 C8                    iny   
3143 31DA B7 8A                 lda   [DecFrm],y               ; check that fdgts is a valid signed byte
3144 31DC 30 08                 bmi   z20s1
3145 31DE D0 75                 bne   ErrXitJ1                 ; fdgts > 255
3146 31E0 A5 81                 lda   fdgts
3147 31E2 10 0A                 bpl   z20s2
3148 31E4 30 6F                 bmi   ErrXitJ1                 ; fdgts > 127
3149 31E6 49 FF        z20s1    eor   #$0ff
3150 31E8 D0 6B                 bne   ErrXitJ1                 ; fdgts < -256
3151 31EA A5 81                 lda   fdgts
3152 31EC 10 67                 bpl   ErrXitJ1                 ; fdgts < -128
3153 31EE A0 05        z20s2    ldy   #$5
3154 31F0 B7 86        z20s3    lda   [src],y                  ; get first 6 bytes of Decimal Rec. into memory
3155 31F2 BB                    tyx   
3156 31F3 95 8A                 sta   sgn,x
3157 31F5 88                    dey   
3158 31F6 10 F8                 bpl   z20s3
3159 31F8 A5 8E                 lda   dsig                     ; get length byte
3160 31FA F0 59                 beq   ErrXitJ1                 ; length = 0 (error)
3161 31FC C9 1D                 cmp   #$1d                     ; a - 29.     <klh 18oct85>
3162 31FE B0 55                 bcs   ErrXitJ1                 ; a >= 29.
3163 3200 A0 00        SgnBlnk  ldy   #$00
3164 3202 38                    sec   
3165 3203 A9 2D                 lda   #$2d                     ; .ascii  '-'
3166 3205 24 8A                 bit   sgn                      ; NOTE: bit instruction does not set 'carry'
3167 3207 D0 06                 bne   z21s2                    ; Obscure, #2d is odd, & has been anded with sgn
3168 3209 A5 80                 lda   fstyle
3169 320B D0 06                 bne   z21s3                    ; Fixed & postive, no leading character
3170 320D A9 20                 lda   #$20                     ; .ascii  ' '
3171 320F 18           z21s2    clc   
3172 3210 C8                    iny   
3173 3211 97 82                 sta   [dst],y
3174 3213 A9 03        z21s3    lda   #$03                     ; offset address of src by 4 or 3
3175 3215 65 86                 adc   src
3176 3217 85 86                 sta   src
3177 3219 90 0A                 bcc   z21s99
3178 321B E6 87                 inc   src+1
3179 321D D0 06                 bne   z21s99
3180 321F E6 88                 inc   src+2
3181 3221 D0 02                 bne   z21s99
3182 3223 E6 89                 inc   src+3
3183 3225 A5 8F        z21s99   lda   frstdig
3184 3227 C9 3F                 cmp   #$3f                     ; '?'
3185 3229 F0 2A                 beq   ErrXitJ1
3186 322B C9 30                 cmp   #$30                     ; '0'
3187 322D D0 0B                 bne   z21s4
3188 322F A2 00                 ldx   #$00
3189 3231 86 8C                 stx   exp                      ; exp <- 0
3190 3233 86 8D                 stx   exp+1
3191 3235 E8                    inx   
3192 3236 86 8E                 stx   dsig                     ; length (sig) <- 1
3193 3238 D0 2D                 bne   Num                      ; branch always
3194 323A              ;  BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS
3195 323A 29 DF        z21s4    and   #$0df                    ; turn off upper/lower case bit
3196 323C C9 4E                 cmp   #$4E                     ; .ascii  'N' or 'n'
3197 323E F0 5A                 beq   NaN1                     ; NAN
3198 3240 C9 49                 cmp   #$49                     ; .ascii  'I' or 'i'
3199 3242 D0 23                 bne   Num                      ; zero, normal or denormal number
3200 3244 A9 49                 lda   #$49                     ; 'I'
3201 3246 C8                    iny   
3202 3247 97 82                 sta   [dst],y
3203 3249 A9 4E                 lda   #$4e                     ; 'N'
3204 324B C8                    iny   
3205 324C 97 82                 sta   [dst],y
3206 324E A9 46                 lda   #$46                     ; 'F'
3207 3250 C8                    iny   
3208 3251 97 82                 sta   [dst],y
3209 3253 D0 0D                 bne   Fin1                     ; branch always
3210 3255              ;  BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS
3211 3255 A9 3F        ErrXitJ1 lda   #$3f                     ; '?'
3212 3257 A0 01                 ldy   #$01
3213 3259 97 82                 sta   [dst],y
3214 325B 98                    tya   
3215 325C 88                    dey   
3216 325D 97 82        Ex1      sta   [dst],y
3217 325F C2 30                 rep   #$30
3218 3261 60                    rts   
3219 3262 98           Fin1     tya   
3220 3263 A0 00                 ldy   #$00
3221 3265 F0 F6                 beq   Ex1                      ; branch always
3222 3267              ;  BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS
3223 3267 A6 80        Num      ldx   fstyle
3224 3269 D0 31                 bne   BgnFxd
3225 326B              ;           ;if f.digits < 1 then f.digits := 1;         { ErrXit ???? }
3226 326B              ;           ;s := concat (s, copy (d.sig, 1, 1));
3227 326B              ;           ;if (f.digits > 1) or (length (d.sig) > 1) then
3228 326B              ;              ;begin
3229 326B              ;                 ;s := concat (s, '.');
3230 326B              ;                 ;if length (d.sig) > 1 then
3231 326B              ;                           ;s := concat (s, copy (d.sig, 2, length (d.sig) - 1));
3232 326B              ;                 ;if f.digits > length (d.sig) then
3233 326B              ;                           ;AppendZeros (f.digits - length (d.sig));
3234 326B C8                    iny                            ; copy one digit before the '.'
3235 326C B7 86                 lda   [src],y
3236 326E 97 82                 sta   [dst],y
3237 3270              ;           ;if (f.digits > 1) or (length (d.sig) > 1) then
3238 3270 C6 8E                 dec   dsig                     ; dsig := dsig - 1
3239 3272 A5 81                 lda   fdgts
3240 3274 C9 02                 cmp   #$02                     ; fdgts - 2
3241 3276 10 08                 bpl   z22s1                    ; fdgts > 1
3242 3278 A9 01                 lda   #$01
3243 327A 85 81                 sta   fdgts
3244 327C A6 8E                 ldx   dsig
3245 327E F0 11                 beq   z22s5                    ; dsig = 1
3246 3280 A9 2E        z22s1    lda   #$2e                     ; '.'
3247 3282 C8                    iny   
3248 3283 97 82                 sta   [dst],y
3249 3285 A6 8E                 ldx   dsig
3250 3287 F0 08                 beq   z22s5
3251 3289 B7 86        z22s3    lda   [src],y                  ; copy after the '.'
3252 328B C8                    iny   
3253 328C 97 82                 sta   [dst],y
3254 328E CA                    dex   
3255 328F D0 F8                 bne   z22s3
3256 3291 A9 FF        z22s5    lda   #$0ff
3257 3293 45 8E                 eor   dsig                     ; a := -dsig
3258 3295 30 75                 bmi   FromFlt                  ; branch always
3259 3297              ;  BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS
3260 3297 18           Err1     clc   
3261 3298 90 BB                 bcc   ErrXitJ1
3262 329A F0 72        NaN1     beq   NaN2
3263 329C A5 8D        BgnFxd   lda   exp+1                    ; check that exp is a valid signed byte
3264 329E 30 08                 bmi   z23s1
3265 32A0 D0 B3                 bne   ErrXitJ1                 ; exp > 255
3266 32A2 A5 8C                 lda   exp
3267 32A4 10 0A                 bpl   BF2
3268 32A6 30 AD                 bmi   ErrXitJ1                 ; exp > 127
3269 32A8 49 FF        z23s1    eor   #$0ff
3270 32AA D0 A9                 bne   ErrXitJ1                 ; exp < -256
3271 32AC A5 8C                 lda   exp
3272 32AE 10 A5                 bpl   ErrXitJ1                 ; exp < -128
3273 32B0 A5 8C        BF2      lda   exp
3274 32B2 18                    clc   
3275 32B3 65 8E                 adc   dsig
3276 32B5 70 9E                 bvs   ErrXitJ1
3277 32B7 AA                    tax   
3278 32B8 30 56                 bmi   AllAftr
3279 32BA F0 54                 beq   AllAftr
3280 32BC A5 8C                 lda   exp
3281 32BE 18                    clc   
3282 32BF 10 1B                 bpl   Before
3283 32C1 65 8E                 adc   dsig
3284 32C3 C8           z24s1    iny                            ; copy before the '.'
3285 32C4 B7 86                 lda   [src],y
3286 32C6 97 82                 sta   [dst],y
3287 32C8 CA                    dex   
3288 32C9 D0 F8                 bne   z24s1
3289 32CB A9 2E                 lda   #$2e                     ; '.'
3290 32CD C8                    iny   
3291 32CE 97 82                 sta   [dst],y
3292 32D0 A6 8C                 ldx   exp
3293 32D2 B7 86        z24s2    lda   [src],y                  ; copy after the '.'
3294 32D4 C8                    iny   
3295 32D5 97 82                 sta   [dst],y
3296 32D7 E8                    inx   
3297 32D8 30 F8                 bmi   z24s2
3298 32DA 10 6D                 bpl   ApZ                      ; branch always
3299 32DC              ;  BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS
3300 32DC A6 8E        Before   ldx   dsig
3301 32DE C8           z25s4    iny                            ; copy all dsig before the '.'
3302 32DF B7 86                 lda   [src],y
3303 32E1 97 82                 sta   [dst],y
3304 32E3 CA                    dex   
3305 32E4 D0 F8                 bne   z25s4
3306 32E6 98                    tya   
3307 32E7 65 8C                 adc   exp                      ; carry cleared above
3308 32E9 70 AC                 bvs   Err1
3309 32EB C9 51                 cmp   #wmaxP1                  ; a - wmaxP1
3310 32ED 10 A8                 bpl   Err1
3311 32EF A6 8C                 ldx   exp
3312 32F1 F0 0A                 beq   z25s6
3313 32F3 A9 30                 lda   #$30                     ; '0'
3314 32F5 C8           z25s5    iny   
3315 32F6 97 82                 sta   [dst],y
3316 32F8 CA                    dex   
3317 32F9 D0 FA                 bne   z25s5
3318 32FB 86 8C                 stx   exp
3319 32FD E4 81        z25s6    cpx   fdgts                    ; x - fdgts
3320 32FF 10 48                 bpl   ApZ                      ; fdgts <= 0
3321 3301 C0 50                 cpy   #wmax                    ; y - wmax
3322 3303 B0 6D                 bcs   ErrXit
3323 3305 A9 2E                 lda   #$2e                     ; '.'
3324 3307 C8                    iny   
3325 3308 97 82                 sta   [dst],y
3326 330A D0 3D                 bne   ApZ                      ; branch always
3327 330C              ;  BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS
3328 330C 30 3D        FromFlt  bmi   FFlt
3329 330E F0 6A        NaN2     beq   NaN3
3330 3310 CA           AllAftr  dex   
3331 3311 8A                    txa   
3332 3312 E8                    inx   
3333 3313 18                    clc   
3334 3314 65 86                 adc   src
3335 3316 85 86                 sta   src
3336 3318 A9 FF                 lda   #$0ff
3337 331A 65 87                 adc   src+1
3338 331C 85 87                 sta   src+1
3339 331E A9 30                 lda   #$30                     ; '0'
3340 3320 C8                    iny   
3341 3321 97 82                 sta   [dst],y
3342 3323 A9 2E                 lda   #$2e                     ; '.'
3343 3325 C8                    iny   
3344 3326 97 82                 sta   [dst],y
3345 3328 8A                    txa   
3346 3329 F0 0C                 beq   z26s16
3347 332B A9 30                 lda   #$30                     ; '0'
3348 332D C8           z26s15   iny   
3349 332E C0 51                 cpy   #wmaxP1                  ; a - wmaxP1
3350 3330 B0 40                 bcs   ErrXit
3351 3332 97 82                 sta   [dst],y
3352 3334 E8                    inx   
3353 3335 D0 F6                 bne   z26s15
3354 3337              ;; adjust the address of source, possibly restructuring ErrXit above
3355 3337 98           z26s16   tya   
3356 3338 18                    clc   
3357 3339 65 8E                 adc   dsig
3358 333B C9 51                 cmp   #wmaxP1                  ; a - wmaxP1
3359 333D 10 33                 bpl   ErrXit
3360 333F A6 8E                 ldx   dsig
3361 3341 B7 86        z26s17   lda   [src],y                  ; copy all dsig after the '.'
3362 3343 C8                    iny   
3363 3344 97 82                 sta   [dst],y
3364 3346 CA                    dex   
3365 3347 D0 F8                 bne   z26s17
3366 3349              ;	;if d.exp >= -f.digits then AppendZeros (f.digits + d.exp);
3367 3349 A5 8C        ApZ      lda   exp
3368 334B 18           FFlt     clc   
3369 334C 65 81                 adc   fdgts
3370 334E 70 22                 bvs   ErrXit                   ;
3371 3350 30 14                 bmi   fine
3372 3352 F0 12                 beq   fine
3373 3354 AA                    tax   
3374 3355 84 81                 sty   temp+1
3375 3357 18                    clc   
3376 3358 65 81                 adc   temp+1
3377 335A C9 51                 cmp   #wmaxP1                  ; a - wmaxP1
3378 335C 10 14                 bpl   ErrXit
3379 335E A9 30                 lda   #$30                     ; '0'
3380 3360 C8           z27s9    iny   
3381 3361 97 82                 sta   [dst],y
3382 3363 CA                    dex   
3383 3364 D0 FA                 bne   z27s9
3384 3366 A6 80        fine     ldx   fstyle
3385 3368 F0 5E                 beq   BgnExp
3386 336A 98           fin      tya   
3387 336B A0 00                 ldy   #$00
3388 336D 97 82                 sta   [dst],y
3389 336F C2 30                 rep   #$30
3390 3371 60                    rts   
3391 3372 A9 3F        ErrXit   lda   #$3f                     ; '?'
3392 3374 A0 01                 ldy   #$01
3393 3376 97 82                 sta   [dst],y
3394 3378 D0 F0                 bne   fin
3395 337A              ;  BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS
3396 337A              ;;------------------------------------------------------------------------------
3397 337A              ;;
3398 337A              ;; change unsigned binary number in exp into a BCD number in BCD to BCD+2
3399 337A              ;;
3400 337A              ;;------------------------------------------------------------------------------
3401 337A 85 8F        NaN3     sta   frstdig
3402 337C C8                    iny   
3403 337D 97 82                 sta   [dst],y
3404 337F A9 41                 lda   #$41                     ; 'A'
3405 3381 C8                    iny   
3406 3382 97 82                 sta   [dst],y
3407 3384 84 8B                 sty   MinDig
3408 3386 A9 4E                 lda   #$4e                     ; 'N'
3409 3388 C8                    iny   
3410 3389 97 82                 sta   [dst],y
3411 338B A9 28                 lda   #$28                     ; '('
3412 338D C8                    iny   
3413 338E 97 82                 sta   [dst],y
3414 3390 84 81                 sty   temp+1                   ; save y
3415 3392 C8                    iny   
3416 3393 C8                    iny   
3417 3394 C8                    iny   
3418 3395 A9 29                 lda   #$29                     ; ')'
3419 3397 C8                    iny   
3420 3398 97 82                 sta   [dst],y
3421 339A 98                    tya   
3422 339B A0 00                 ldy   #$00
3423 339D 97 82                 sta   [dst],y
3424 339F 98                    tya                            ; initialize exp
3425 33A0 A4 8B                 ldy   MinDig                   ; restore y
3426 33A2 A6 8E                 ldx   dsig
3427 33A4 E0 06                 cpx   #$06                     ; y - wmax
3428 33A6 90 02                 bcc   z28s3                    ; x < 6
3429 33A8 A2 05                 ldx   #$05
3430 33AA CA           z28s3    dex   
3431 33AB F0 15                 beq   z28s5
3432 33AD 0A                    asl   a
3433 33AE 0A                    asl   a
3434 33AF 0A                    asl   a
3435 33B0 0A                    asl   a
3436 33B1 85 8C                 sta   exp
3437 33B3 B7 86                 lda   [src],y
3438 33B5 C9 40                 cmp   #$40                     ; a - #40
3439 33B7 90 02                 bcc   z28s4                    ; not a letter
3440 33B9 69 08                 adc   #$08
3441 33BB 29 0F        z28s4    and   #$0f
3442 33BD 05 8C                 ora   exp
3443 33BF C8                    iny   
3444 33C0 D0 E8                 bne   z28s3
3445 33C2              ;  BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS
3446 33C2              ;      ;ldx     #00
3447 33C2 85 8C        z28s5    sta   exp
3448 33C4 A9 FC                 lda   #$0fc                    ; -4
3449 33C6 D0 31                 bne   codeNaN                  ; branch always
3450 33C8              ;  BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS   BRANCH ALWAYS
3451 33C8              ;           ;STR (d.exp + length (d.sig) - 1, SExp);     { no check for wrap }
3452 33C8              ;           ;if SExp [1] <> '-' then SExp := concat ('+', SExp);
3453 33C8              ;           ;if (length (s) + length (SExp)) < Wmax then
3454 33C8              ;               ;s := concat (s, 'e', SExp)
3455 33C8              ;           ;else ErrXit;
3456 33C8 C0 54        BgnExp   cpy   #wmaxP4                  ; a - wmaxP4
3457 33CA B0 A6        ErrXit3  bcs   ErrXit
3458 33CC A9 65                 lda   #$65                     ; 'e'
3459 33CE C8                    iny   
3460 33CF 97 82                 sta   [dst],y
3461 33D1              ;      ;ldx     #00	            ; set above by 'ldx     fstyle'
3462 33D1              ;      ;clc	            ; reset	    by 'cpy     #wmaxP4
3463 33D1 A5 8E                 lda   dsig
3464 33D3 65 8C                 adc   exp
3465 33D5 85 8C                 sta   exp
3466 33D7 8A                    txa   
3467 33D8 65 8D                 adc   exp+1
3468 33DA 85 8D                 sta   exp+1
3469 33DC 70 94                 bvs   ErrXit                   ; exponent overflows integer value
3470 33DE 30 04                 bmi   z29s1
3471 33E0 A9 2B                 lda   #$2b                     ; '+'
3472 33E2 D0 0D                 bne   z29s2                    ; branch always
3473 33E4 38           z29s1    sec   
3474 33E5 8A                    txa   
3475 33E6 E5 8C                 sbc   exp
3476 33E8 85 8C                 sta   exp
3477 33EA 8A                    txa   
3478 33EB E5 8D                 sbc   exp+1
3479 33ED 85 8D                 sta   exp+1
3480 33EF A9 2D                 lda   #$2d                     ; '-'
3481 33F1 C8           z29s2    iny   
3482 33F2 97 82                 sta   [dst],y
3483 33F4 A9 FA                 lda   #$0fa                    ; -6
3484 33F6 E8                    inx   
3485 33F7 84 81                 sty   temp+1                   ; save y
3486 33F9 85 8B        codeNaN  sta   MinDig
3487 33FB A9 00                 lda   #$00
3488 33FD 85 86                 sta   BCD
3489 33FF 85 87                 sta   BCD+1
3490 3401 85 88                 sta   BCD+2
3491 3403 F8                    sed   
3492 3404 A0 08        z30s0    ldy   #$08                     ; number of valid bits per byte
3493 3406 16 8C        z30s1    asl   exp,x
3494 3408 A5 86                 lda   BCD
3495 340A 65 86                 adc   BCD
3496 340C 85 86                 sta   BCD
3497 340E A5 87                 lda   BCD+1
3498 3410 65 87                 adc   BCD+1
3499 3412 85 87                 sta   BCD+1
3500 3414 A5 88                 lda   BCD+2
3501 3416 65 88                 adc   BCD+2
3502 3418 85 88                 sta   BCD+2
3503 341A 88                    dey   
3504 341B D0 E9                 bne   z30s1
3505 341D CA                    dex   
3506 341E 10 E4                 bpl   z30s0
3507 3420 D8                    cld   
3508 3421 A4 81                 ldy   temp+1                   ; restore y
3509 3423 A2 02        N2Ascii  ldx   #$2
3510 3425 B5 86        z31s1    lda   BCD,x
3511 3427 4A                    lsr   a
3512 3428 4A                    lsr   a
3513 3429 4A                    lsr   a
3514 342A 4A                    lsr   a
3515 342B F0 02                 beq   z31s2                    ; zero encountered
3516 342D 85 8B                 sta   MinDig
3517 342F E6 8B        z31s2    inc   MinDig
3518 3431 30 09                 bmi   z31s4
3519 3433 09 30                 ora   #$30
3520 3435 C8                    iny   
3521 3436 C0 51                 cpy   #wmaxP1                  ; y - wmaxP1
3522 3438 B0 90        z31s3    bcs   ErrXit3
3523 343A 97 82                 sta   [dst],y
3524 343C B5 86        z31s4    lda   BCD,x
3525 343E 29 0F                 and   #$0f
3526 3440 F0 02                 beq   z31s5                    ; zero encountered
3527 3442 85 8B                 sta   MinDig
3528 3444 E6 8B        z31s5    inc   MinDig
3529 3446 30 09                 bmi   z31s6
3530 3448 09 30                 ora   #$30
3531 344A C8                    iny   
3532 344B C0 51                 cpy   #wmaxP1                  ; y - wmaxP1
3533 344D B0 E9                 bcs   z31s3                    ; ErrXit3
3534 344F 97 82                 sta   [dst],y
3535 3451 CA           z31s6    dex   
3536 3452 10 D1                 bpl   z31s1
3537 3454 A5 8F                 lda   frstdig
3538 3456 C9 4E                 cmp   #$4e
3539 3458 F0 05                 beq   rts3
3540 345A 98                    tya   
3541 345B A0 00                 ldy   #$00
3542 345D 97 82                 sta   [dst],y
3543 345F                       longa on
3544 345F                       longi on
3545 345F C2 30        rts3     rep   #$30
3546 3461 60                    rts   
3547 3462                       ENDP 
3548 3462
3549 3462                       EXPORT CStr2Dec 
3550 3462              CStr2Dec PROC 
3551 3462              ;          copy sane/str2dec1
3552 3462              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3553 3462              ;; File:  Str2Dec.TEXT
3554 3462              ;; Decimal string scanner for 6502
3555 3462              ;; Status: BETA
3556 3462              ;; Copyright Apple Computer, Inc. 1984,1985
3557 3462              ;;
3558 3462              ;; Written by Clayton Lewis, Apple Numerics Group, 27 September 1984
3559 3462              ;;
3560 3462              ;; Modification History:
3561 3462              ;;    14 May 84  JTC  Original 68000 code named ScanDec
3562 3462              ;;    03 Oct 84  CRL  CStr2Dec entry point for character streams
3563 3462              ;;    18 Oct 84  CRL  Clean and compact the code
3564 3462              ;;    05 Nov 84  CRL  No longer accept Ascii with high bit set
3565 3462              ;;                    Signalling NaN delivered if no characters accepted
3566 3462              ;;    15 Jan 85  RwH  (Think) changed .includes for my directory structure.
3567 3462              ;;                    changed .org to XORG.  Added XEND at end.
3568 3462              ;;    03 Feb 85  rwh  changed % to ? in macros...added .ref FP6502
3569 3462              ;;    15 feb 85  rwh  deleted .ref FP6502 - its back to being in Think's ORGS
3570 3462              ;;                    file.
3571 3462              ;;    16 mar 85  rwh  added .nolists for faster assembly
3572 3462              ;;    17 May 85  CRL  Bug in State2.  The string '0)' left index in limbo.
3573 3462              ;;                    Fix in State2 is marked by  {add 4 lines 17 May 85 CRL}
3574 3462              ;;    23 May 85  CRL  Fold in ongoing changes: AppendDigit to ignore characters
3575 3462              ;;                    after 28th,(13 Mar 85).  NaN signalling bit change at SNaN
3576 3462              ;;                    and State99 for 68881 and 68000 compatibility, (19 Mar 85)
3577 3462              ;;    19 Jun 85  CRL  Change constant from 2 to 4 in 'State99, process NaNcode'.
3578 3462              ;;                    Fixes bug in IP; nancode now in correct byte.
3579 3462              ;;    11 Jul 85  CRL  Bug in state6.  '..' handled wrong.  Fix moves local label
3580 3462              ;;                    $1 up by three lines, replaces LDA with LDX.
3581 3462              ;;    29 Aug 85  klh  Butchered to assemble on the ///.
3582 3462              ;;    18 Oct 85  klh  More mutilation to assemble under ORCA/M.
3583 3462              ;;     7 May 86  klh  Altered to run in 65816 native mode with 8-bit registers.
3584 3462              ;;              ________________________________________________
3585 3462              ;;
3586 3462              ;; Define storage on zero page and set switches for machine/environment:
3587 3462              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3588 3462
3589 3462              ADDRESSINDIRECT equ   128               ; start of zero page use
3590 3462              REGISTERS equ   160
3591 3462              VP       equ   ADDRESSINDIRECT
3592 3462              D        equ   ADDRESSINDIRECT+4
3593 3462              INDEX    equ   ADDRESSINDIRECT+8
3594 3462              thisS    equ   ADDRESSINDIRECT+12
3595 3462              DSIGLOC  equ   ADDRESSINDIRECT+16
3596 3462              CHARPTR  equ   REGISTERS                ; ^char interface needs 2 bytes
3597 3462              SAVEDCHARPTR equ   REGISTERS+2
3598 3462              LASTCHARPTR equ   REGISTERS+4
3599 3462              NaNCODE  equ   REGISTERS+5
3600 3462              FLZERO   equ   REGISTERS+6
3601 3462              FLVALPREF equ   REGISTERS+7
3602 3462              FLEXPSGN equ   REGISTERS+8
3603 3462              STACKADJ equ   REGISTERS+9
3604 3462              DSIGLENGTH equ   REGISTERS+10
3605 3462              EXPONENT equ   REGISTERS+11
3606 3462              EXPADJUST equ   REGISTERS+13
3607 3462              STMP     equ   REGISTERS+15
3608 3462              CSTRING  equ   REGISTERS+16
3609 3462              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3610 3462              ;; Define constants.
3611 3462              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3612 3462              SIGDIGLEN equ   28                      ; note: 20 for the 68000
3613 3462              TAB      equ   $09
3614 3462              BLANK    equ   $20
3615 3462              OPENPAREN equ   $28
3616 3462              CLOSEPAREN equ   $29
3617 3462              PLUS     equ   $2B
3618 3462              MINUS    equ   $2D
3619 3462              DOT      equ   $2E
3620 3462              ZERO     equ   $30
3621 3462              ONE      equ   $31
3622 3462              FOUR     equ   $34                      ; {addition 23 May 85  CRL}
3623 3462              NINE     equ   $39
3624 3462              COLON    equ   $3A
3625 3462              BIGA     equ   $41
3626 3462              E        equ   $45
3627 3462              F        equ   $46
3628 3462              I        equ   $49
3629 3462              N        equ   $4E
3630 3462              SMALLa   equ   $61
3631 3462              SMALLe   equ   $65
3632 3462              zPLUS1   equ   $7B
3633 3462              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3634 3462              ;; Start of routine, note the 2 entry points:  Str2Dec and CStr2Dec.
3635 3462              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3636 3462 A2 00 00              ldx   #$0
3637 3465 4C 6B 34              jmp   Start2
3638 3468                       EXPORT Str2Dec 
3639 3468              Str2Dec                                 ;       
3640 3468 A2 01 00              ldx   #$1
3641 346B              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3642 346B              ;; Save items passed on the stack and initialize flags.
3643 346B              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3644 346B 86 B0        start2   stx   CSTRING                  ; no length byte if CSTRING is 0
3645 346D 7A                    ply   
3646 346E A2 00 00              ldx   #$0                      ; first save 16 bytes from stack
3647 3471 68           z2s1     pla   
3648 3472 95 80                 sta   ADDRESSINDIRECT,X
3649 3474 E8                    inx   
3650 3475 E8                    inx   
3651 3476 E0 10 00              cpx   #16
3652 3479 90 F6                 bcc   z2s1
3653 347B 5A                    phy   
3654 347C A2 10 00              ldx   #$10                     ; 16 slots to zero
3655 347F CA           z2s2     dex   
3656 3480 CA                    dex   
3657 3481 74 A0                 stz   REGISTERS,X
3658 3483 D0 FA                 bne   z2s2
3659 3485 9B                    txy                            ; putting 0 into Y
3660 3486                       longa off
3661 3486                       longi off
3662 3486 E2 30                 sep   #$30
3663 3488 B7 88                 lda   [INDEX],Y
3664 348A 85 A0                 sta   CHARPTR                  ; offset from start of S
3665 348C 85 A2                 sta   SAVEDCHARPTR
3666 348E A6 B0                 ldx   CSTRING
3667 3490 F0 0C                 beq   z2s3
3668 3492 B7 8C                 lda   [thisS],Y                ; length byte of S
3669 3494 85 A4                 sta   LASTCHARPTR              ; offset from start of S
3670 3496 C8                    iny                            ; Y now has 1
3671 3497 B7 88                 lda   [INDEX],Y                ; look at hi byte of index
3672 3499 F0 0F                 beq   z2s5                     ;    OK if zero
3673 349B 4C 55 36              jmp   StateFin                 ;    exit if index too large
3674 349E C8           z2s3     iny                            ; keep the hi byte of index also
3675 349F B7 88                 lda   [INDEX],Y
3676 34A1 85 A1                 sta   CHARPTR+1
3677 34A3 85 A3                 sta   SAVEDCHARPTR+1
3678 34A5 18                    clc                            ; then advance the same number of
3679 34A6 65 8D                 adc   thisS+1                  ;    pages into the buffer S so
3680 34A8 85 8D                 sta   thisS+1                  ;    Y can index into next page
3681 34AA 18           z2s5     clc                            ; set up pointer to d.sig
3682 34AB A5 84                 lda   D                        ;    4 bytes into D
3683 34AD 69 04                 adc   #$4
3684 34AF 85 90                 sta   DSIGLOC
3685 34B1 A5 85                 lda   D+1
3686 34B3 69 00                 adc   #$0
3687 34B5 85 91                 sta   DSIGLOC+1
3688 34B7 A5 86                 lda   D+2
3689 34B9 69 00                 adc   #$0
3690 34BB 85 92                 sta   DSIGLOC+2
3691 34BD A5 87                 lda   D+3
3692 34BF 69 00                 adc   #$0
3693 34C1 85 93                 sta   DSIGLOC+3
3694 34C3              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3695 34C3              ;; Initialize the decimal record to sign +, EXPONENT 0 and significand N0011.
3696 34C3              ;;      Use SNaN = 00 00 00 00 05 4E 30 30 31 31  = (0)(0)(0)(0)(5)'N0011'
3697 34C3              ;;      {change only to comment: 23 May 85 CRL, signaling NaN bit change}
3698 34C3              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3699 34C3 A0 09        InitDec  ldy   #$9
3700 34C5 B9 51 37     z3s1     lda   SNaN,Y                   ; data for SNaN at end of file
3701 34C8 97 84                 sta   [D],Y
3702 34CA 88                    dey   
3703 34CB 10 F8                 bpl   z3s1
3704 34CD              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3705 34CD              ;; State0 -- scan leading white space. Blanks and tab characters.
3706 34CD              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3707 34CD 20 48 35     State0   jsr   GetChar
3708 34D0 C9 20                 cmp   #BLANK                   ; blank
3709 34D2 F0 F9                 beq   State0
3710 34D4 C9 09                 cmp   #TAB                     ; tab
3711 34D6 F0 F5                 beq   State0
3712 34D8              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3713 34D8              ;; Then fall through to State1 looking for a sign.
3714 34D8              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3715 34D8 C9 2B        State1   cmp   #PLUS
3716 34DA F0 0E                 beq   z4s1                     ; +, go on since d.sgn already = 0
3717 34DC C9 2D                 cmp   #MINUS
3718 34DE D0 0D                 bne   State2                   ; not +/-, check for number
3719 34E0 A9 01                 lda   #$1                      ; -, so store 0001 in d.sgn
3720 34E2 A0 00                 ldy   #$0
3721 34E4 97 84                 sta   [D],Y
3722 34E6 98                    tya   
3723 34E7 C8                    iny   
3724 34E8 97 84                 sta   [D],Y
3725 34EA 20 48 35     z4s1     jsr   GetChar
3726 34ED              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3727 34ED              ;; Now expect to have INF, NaN, or number.
3728 34ED              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3729 34ED C9 30        State2   cmp   #ZERO                    ; look for leading zeros
3730 34EF 90 0D                 bcc   z5s1                     ;    character < '0'
3731 34F1 D0 19        z5s0     bne   z5s2                     ;    character > '0'
3732 34F3 38                    sec   
3733 34F4 26 A6                 rol   FLZERO                   ; zero seen, set lo bit of FLZERO
3734 34F6 20 2F 37              jsr   ClearSavedPtr            ; use current scan pointer
3735 34F9 20 48 35              jsr   GetChar                  ; try again with a new character
3736 34FC B0 F3                 bcs   z5s0                     ; branch if char is '0' or greater
3737 34FE C9 2E        z5s1     cmp   #DOT                     ; only interesting character < 0
3738 3500 F0 70                 beq   State6                   ; dot found before signif digits
3739 3502              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3740 3502              ;       ;; {Add 4 lines 17 May 85 CRL}
3741 3502              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3742 3502 A5 A6                 lda   FLZERO
3743 3504 F0 03                 beq   z5s3
3744 3506 4C 15 36              jmp   StateNum
3745 3509 4C E5 36     z5s3     jmp   StateBackup              ; illegitimate number
3746 350C C9 3A        z5s2     cmp   #COLON
3747 350E 90 0A                 bcc   State4                   ; digits follow, go scan them
3748 3510 A4 A6                 ldy   FLZERO                   ; any leading zero's?
3749 3512 D0 03                 bne   GoTo8                    ;    if so, try E,e
3750 3514 4C 6A 36              jmp   State99                  ;    if not, try INF, NaN
3751 3517 4C AE 35     GoTo8    jmp   State8
3752 351A              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3753 351A              ;; State4 -- Scan significant digits before the decimal point.  Uses
3754 351A              ;;      AppendDigit to place digit in string, get next character, and
3755 351A              ;;      compare next character to 0.
3756 351A              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3757 351A 20 2F 37     State4   jsr   ClearSavedPtr            ; use current scan pointer
3758 351D 20 35 35     z6s1     jsr   AppendDigit
3759 3520 90 04                 bcc   State5                   ; character < '0', so look for dot
3760 3522 C9 3A                 cmp   #COLON                   ; one greater than '9'
3761 3524 90 F7                 bcc   z6s1                     ; =< 3A,   so character in 0..9
3762 3526              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3763 3526              ;; State5 -- check for start of fraction field after some significant
3764 3526              ;;      digits have already been scanned.
3765 3526              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3766 3526 C9 2E        State5   cmp   #DOT
3767 3528 D0 ED                 bne   GoTo8                    ; try EXPONENT field (State8)
3768 352A 20 48 35              jsr   GetChar
3769 352D B0 03                 bcs   z7s1                     ; potential digits
3770 352F 4C 15 36              jmp   StateNum                 ; dot followed by no digits, end
3771 3532 4C AA 35     z7s1     jmp   State75
3772 3535              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3773 3535              ;; AppendDigit
3774 3535              ;;      - Place numeral in digit field of decimal
3775 3535              ;;      - Get next character
3776 3535              ;;      - Compare with '0' before returning
3777 3535              ;;        {remove last comment: 13 Mar 85 CRL}
3778 3535              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3779 3535 A4 AA        AppendDigit ldy   DSIGLENGTH
3780 3537 C0 1C                 cpy   #SIGDIGLEN               ; past all valid digits?
3781 3539 B0 07                 bcs   z8s3                     ;    if so, just count lost digits
3782 353B C8                    iny                            ;    if not, advance pointer
3783 353C 84 AA                 sty   DSIGLENGTH               ;    and store digit in d.sig
3784 353E 97 90                 sta   [DSIGLOC],Y
3785 3540 D0 06                 bne   GetChar                  ; always
3786 3542              ;{13 Mar 85 CRL}       ORA     @DSIGLOC,Y   ; OR into 28th digit
3787 3542              ;{13 Mar 85 CRL}       STA     @DSIGLOC,Y
3788 3542 E6 AD        z8s3     inc   EXPADJUST                ; record the # of lost digits
3789 3544 D0 02                 bne   GetChar
3790 3546 E6 AE                 inc   EXPADJUST+1
3791 3548              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3792 3548              ;; GetChar
3793 3548              ;;      - STACKADJ <-- # bytes of return addresses on stack
3794 3548              ;;      - Check for end of scanning string
3795 3548              ;;      - Collect next character (if not at string end)
3796 3548              ;;      - Set ValidPrefix to TRUE if at string end
3797 3548              ;;      - See if saved instead of current pointer should be returned
3798 3548              ;;
3799 3548              ;; Note the two entry points.  GETCHAR2 is called by GETMAPPED with 4 in A.
3800 3548              ;;      Since GETMAPPED calls via JSR, there are two return addresses
3801 3548              ;;      to pop if scan ends prematurely and we do not return to caller.
3802 3548              ;;      Other calls need to pop only one return address.
3803 3548              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3804 3548 A9 02        GetChar  lda   #$2                      ; stack adjustment if abort
3805 354A 85 A9        GetChar2 sta   STACKADJ
3806 354C 20 3F 37              jsr   CheckEndScan             ; end of scan?
3807 354F 90 0F                 bcc   z9s7                     ;    if so, branch
3808 3551 A4 A0                 ldy   CHARPTR                  ;    else get next character
3809 3553 B7 8C                 lda   [thisS],Y
3810 3555 E6 A0                 inc   CHARPTR
3811 3557 D0 04                 bne   z9s5
3812 3559 E6 A1                 inc   CHARPTR+1
3813 355B E6 8D                 inc   thisS+1
3814 355D C9 30        z9s5     cmp   #ZERO
3815 355F 60                    rts   
3816 3560 E6 A7        z9s7     inc   FLVALPREF                ; premature string end
3817 3562 A4 A9                 ldy   STACKADJ                 ; pop return address(es)
3818 3564 68           z9s9     pla   
3819 3565 88                    dey   
3820 3566 D0 FC                 bne   z9s9
3821 3568 A4 A3                 ldy   SAVEDCHARPTR+1           ; has a pointer been saved?
3822 356A 30 03                 bmi   z9s11                    ;    if not, just exit
3823 356C 4C E5 36              jmp   StateBackup              ;    else reset ptr, then exit
3824 356F 4C 1D 36     z9s11    jmp   StNum2
3825 3572              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3826 3572              ;; State6 -- encountered dot before any nonzero significant digits.  Keep
3827 3572              ;; looking for digits, but throw away leading zeros, remembering placement
3828 3572              ;; of decimal.  If possible nonzero digit or letter, skip right into fraction
3829 3572              ;; digit scanner.
3830 3572              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3831 3572 20 48 35     State6   jsr   GetChar                  ; skip past dot
3832 3575 F0 10                 beq   z10s3                    ; if zero, branch
3833 3577 90 04                 bcc   z10s1                    ; if less than zero, end
3834 3579 C9 3A                 cmp   #COLON                   ; > zero, but is it 9 or less?
3835 357B 90 1A                 bcc   State7                   ;    if 1..9, next state
3836 357D              ;       ;; Local label $1 moved to next line from previous location
3837 357D              ;       ;;   4 lines down between two JMP instructions.
3838 357D              ;       ;; Change next instruction to LDX instead of LDA. 11 July 85  CRL
3839 357D A6 A6        z10s1    ldx   FLZERO                   ; no digits, were there 0's?
3840 357F D0 2D                 bne   State8                   ;    if so, try E,e
3841 3581 4C E5 36              jmp   StateBackup              ;    else return to begin of scan
3842 3584 4C 15 36              jmp   StateNum
3843 3587 38           z10s3    sec   
3844 3588 26 A6                 rol   FLZERO                   ; character = '0', set flag
3845 358A 20 2F 37              jsr   ClearSavedPtr            ; use current character pointer
3846 358D A6 AD                 ldx   expadjust
3847 358F D0 02                 bne   z10s12
3848 3591 C6 AE                 dec   expadjust+1
3849 3593 C6 AD        z10s12   dec   expadjust
3850 3595 D0 DB                 bne   State6                   ; and look for more 0's  (always)
3851 3597              ;          copy sane/str2dec2
3852 3597              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3853 3597              ;; State7 -- scan fraction digits.  Use AppendDigit and keep count of the
3854 3597              ;; number of digits scanned, whether in excess of 28 or not.
3855 3597              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3856 3597 20 2F 37     State7   jsr   ClearSavedPtr            ; use current character pointer
3857 359A A6 AD                 ldx   expadjust                ; count number of fraction digits
3858 359C D0 02                 bne   z11s12
3859 359E C6 AE                 dec   expadjust+1
3860 35A0 C6 AD        z11s12   dec   expadjust
3861 35A2 20 35 35              jsr   AppendDigit
3862 35A5 B0 03                 bcs   State75                  ; if > zero, keep looking
3863 35A7 4C 15 36              jmp   StateNum                 ;    else done
3864 35AA C9 3A        State75  cmp   #COLON                   ; exit if character > '9'
3865 35AC 90 E9                 bcc   State7
3866 35AE              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3867 35AE              ;; State8 -- look for EXPONENT: E or e followed be optional sign and a digit
3868 35AE              ;; field.  Must be careful about EXPONENT overflow.  Since the extended
3869 35AE              ;; range admits values in magnitude between 10^-5000 and 10^5000, it
3870 35AE              ;; suffices to check for EXPONENT outside 4096 + 1024 = 5120.  Overflowed
3871 35AE              ;; EXPONENT are mapped into $1400 (5120), guaranteed to produce a severe
3872 35AE              ;; overflow on conversion.
3873 35AE              ;;
3874 35AE              ;; Must also guard against overscan of expressions like '123e-'.  We must
3875 35AE              ;; return 123 with pointer at 'e'.  If E or e is found, hold input pointer
3876 35AE              ;; in case subsequent scanning does not make sense of the characters past
3877 35AE              ;; '123'.
3878 35AE              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3879 35AE 20 36 37     State8   jsr   UpdatePtr                ; save current character pointer
3880 35B1 A6 A2                 ldx   savedcharptr             ; and move it back by one
3881 35B3 D0 02                 bne   z12s12
3882 35B5 C6 A3                 dec   savedcharptr+1
3883 35B7 C6 A2        z12s12   dec   savedcharptr
3884 35B9 C9 45                 cmp   #E
3885 35BB F0 04                 beq   z12s1
3886 35BD C9 65                 cmp   #SMALLe
3887 35BF D0 4D                 bne   z12s15                   ; no EXPONENT found
3888 35C1 20 48 35     z12s1    jsr   GetChar
3889 35C4 C9 2B                 cmp   #PLUS
3890 35C6 F0 06                 beq   z12s3
3891 35C8 C9 2D                 cmp   #MINUS
3892 35CA D0 05                 bne   z12s5
3893 35CC E6 A8                 inc   FLEXPSGN                 ; mark as negative EXPONENT
3894 35CE 20 48 35     z12s3    jsr   GetChar                  ; skip past sign character
3895 35D1 C9 30        z12s5    cmp   #ZERO                    ; >= '0'?
3896 35D3 90 39                 bcc   z12s15                   ;   if not, end digit field
3897 35D5 C9 3A                 cmp   #COLON                   ; =< '9'?
3898 35D7 B0 35                 bcs   z12s15                   ;   if not, end  digit field
3899 35D9 20 2F 37              jsr   ClearSavedPtr            ; digit, use current char pointer
3900 35DC 29 0F                 and   #$0F                     ; mask to nibble
3901 35DE AA                    tax                            ; hold digit in X until end of loop
3902 35DF              ;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3903 35DF              ;          ;; Multiply EXPONENT by 10
3904 35DF              ;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3905 35DF 06 AB                 asl   EXPONENT                 ; first multiply by 2
3906 35E1 26 AC                 rol   EXPONENT+1               ;   EXPONENT word * 2
3907 35E3 A5 AC                 lda   EXPONENT+1
3908 35E5 85 AF                 sta   STMP                     ; copy to A register and STMP
3909 35E7 A5 AB                 lda   EXPONENT                 ;   then multiply those by 4
3910 35E9 0A                    asl   A                        ;   to get EXPONENT * 8
3911 35EA 26 AF                 rol   STMP
3912 35EC 0A                    asl   A
3913 35ED 26 AF                 rol   STMP                     ; note that carry is not set so...
3914 35EF 65 AB                 adc   EXPONENT                 ; now add Exp * 2 + Exp * 8
3915 35F1 85 AB                 sta   EXPONENT                 ;    to get EXPONENT * 10
3916 35F3 A5 AF                 lda   STMP
3917 35F5 65 AC                 adc   EXPONENT+1
3918 35F7 85 AC                 sta   EXPONENT+1
3919 35F9              ;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3920 35F9              ;          ;; And add in the current digit.
3921 35F9              ;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3922 35F9 18                    clc   
3923 35FA 8A                    txa                            ; pick up digit from X
3924 35FB 65 AB                 adc   EXPONENT
3925 35FD 85 AB                 sta   EXPONENT
3926 35FF 90 02                 bcc   z12s9
3927 3601 E6 AC                 inc   EXPONENT+1
3928 3603 A9 14        z12s9    lda   #$14
3929 3605 C5 AC                 cmp   EXPONENT+1               ; EXPONENT >= 5120? (overflow)
3930 3607 B0 02                 bcs   z12s13                   ;    if not, continue
3931 3609 85 AC                 sta   EXPONENT+1               ;    else just use 5120
3932 360B 4C CE 35     z12s13   jmp   z12s3
3933 360E              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3934 360E              ;       ;; Finish scan by checking to see whether we have overscanned.
3935 360E              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3936 360E A4 A3        z12s15   ldy   SAVEDCHARPTR+1           ; overscan?
3937 3610 30 03                 bmi   StateNum                 ;    if not, go on
3938 3612 4C E5 36              jmp   StateBackup              ;    if so, reset pointer
3939 3615              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3940 3615              ;; StateNum -- have sighted the first unrecognizable character after a
3941 3615              ;; possible number.  Check first for 0, a special case since all digits
3942 3615              ;; were discarded above, then put the number in canonical form.
3943 3615              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3944 3615 A6 A0        StateNum ldx   charptr
3945 3617 D0 02                 bne   z13s12
3946 3619 C6 A1                 dec   charptr+1
3947 361B C6 A0        z13s12   dec   charptr
3948 361D A0 00        StNum2   ldy   #$0                      ; needed at $2 and 5 lines down
3949 361F A5 AA                 lda   DSIGLENGTH               ; any digits?
3950 3621 D0 0F                 bne   z14s2                    ;    if so, branch
3951 3623 A5 A6                 lda   FLZERO                   ;    if none, 0?
3952 3625 F0 2E                 beq   StateFin                 ;       not even 0!! (branch always)
3953 3627 A9 01                 lda   #$1                      ; if 0, then return d.sig = 0
3954 3629 97 90                 sta   [DSIGLOC],Y              ; length byte of 1 in d.sib
3955 362B C8                    iny   
3956 362C A9 30                 lda   #$30                     ; then the '0' character
3957 362E 97 90                 sta   [DSIGLOC],Y
3958 3630 D0 23                 bne   StateFin                 ; always
3959 3632              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3960 3632              ;       ;; Have nonzero number with:
3961 3632              ;       ;;      - DSIGLENGTH digits
3962 3632              ;       ;;      - Positive binary exponent in EXPONENT, EXPONENT+1
3963 3632              ;       ;;      - Lost digit count minus fraction digit count in EXPADJUST
3964 3632              ;       ;;
3965 3632              ;       ;; To align decimal point at the end of d.sig, compute:
3966 3632              ;       ;;      true exponent := EXPONENT + EXPADJUST.
3967 3632              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3968 3632 97 90        z14s2    sta   [DSIGLOC],Y              ; put length byte in d.sig
3969 3634 A5 A8                 lda   FLEXPSGN                 ; negative exponent?
3970 3636 F0 0D                 beq   z14s5                    ;    if not, branch
3971 3638              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3972 3638              ;       ;; Negate the integer EXPONENT.
3973 3638              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3974 3638 38                    sec   
3975 3639 A9 00                 lda   #$0
3976 363B E5 AB                 sbc   EXPONENT
3977 363D 85 AB                 sta   EXPONENT
3978 363F A9 00                 lda   #$0
3979 3641 E5 AC                 sbc   EXPONENT+1
3980 3643 85 AC                 sta   EXPONENT+1
3981 3645              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3982 3645              ;       ;; Finish up with the final addition.
3983 3645              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3984 3645 A0 02        z14s5    ldy   #$2                      ; d.exp occupies bytes 2 & 3 of D
3985 3647 18                    clc   
3986 3648 A5 AB                 lda   EXPONENT
3987 364A 65 AD                 adc   EXPADJUST
3988 364C 97 84                 sta   [D],Y                    ; store the lo byte
3989 364E C8                    iny   
3990 364F A5 AC                 lda   EXPONENT+1
3991 3651 65 AE                 adc   EXPADJUST+1
3992 3653 97 84                 sta   [D],Y                    ; store the hi byte
3993 3655              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3994 3655              ;; StateFin -- replace the updated input pointer INDEX, set the final value
3995 3655              ;; of VALIDPREFIX, and RTS through the return address.
3996 3655              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
3997 3655 A0 00        StateFin ldy   #$0
3998 3657 A5 A0                 lda   CHARPTR
3999 3659 97 88                 sta   [INDEX],Y
4000 365B A5 A7                 lda   FLVALPREF                ; store the low byte
4001 365D 97 80                 sta   [VP],Y
4002 365F 98                    tya                            ; and zero out the hi byte
4003 3660 C8                    iny   
4004 3661 97 80                 sta   [VP],Y
4005 3663 A5 A1                 lda   CHARPTR+1
4006 3665 97 88                 sta   [INDEX],Y
4007 3667 C2 30                 rep   #$30
4008 3669 60                    RTS   
4009 366A              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4010 366A              ;; State99 -- all else has failed, so check for INF and NaN.  Use the saved
4011 366A              ;; character pointer to back up in case a partial scan does not find the
4012 366A              ;; full token for a NaN.  INF is handled at StateINF.
4013 366A              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4014 366A A6 A0        State99  ldx   charptr
4015 366C D0 02                 bne   z15s12
4016 366E C6 A1                 dec   charptr+1
4017 3670 C6 A0        z15s12   dec   charptr
4018 3672 20 16 37              jsr   GetMapped
4019 3675 C9 49                 cmp   #I                       ; test for 'I'
4020 3677 D0 03                 bne   z15s1                    ;    if not, branch
4021 3679 4C F0 36              jmp   StateINF                 ;    if so, try 'INF'
4022 367C C9 4E        z15s1    cmp   #N                       ;    else try 'N'
4023 367E D0 65                 bne   StateBackup              ; if neither, quit looking
4024 3680 20 16 37              jsr   GetMapped
4025 3683 C9 41                 cmp   #BIGA
4026 3685 D0 5E                 bne   StateBackup
4027 3687 20 16 37              jsr   GetMapped
4028 368A C9 4E                 cmp   #N
4029 368C D0 57                 bne   StateBackup
4030 368E              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4031 368E              ;       ;; NaN found.  Replace N0011 with N4000 as default NaN.
4032 368E              ;       ;; {changed 23 May 85  CRL : new sense of signalling NaN bit}
4033 368E              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4034 368E A0 02                 ldy   #$2
4035 3690 A9 34                 lda   #FOUR
4036 3692 97 90                 sta   [DSIGLOC],Y              ; '4' as first digit
4037 3694 A9 30                 lda   #ZERO                    ; prepare to zero out the '11' chars
4038 3696 C8                    iny   
4039 3697 C8                    iny   
4040 3698 97 90                 sta   [DSIGLOC],Y
4041 369A C8                    iny   
4042 369B 97 90                 sta   [DSIGLOC],Y
4043 369D              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4044 369D              ;       ;; Expect string (xxxx) to follow NaN.  Check for it and
4045 369D              ;       ;; translate to a two digit ascii code in hex.  Save the pointer
4046 369D              ;       ;; at NAN in case junk follows.
4047 369D              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4048 369D 20 36 37              jsr   UpdatePtr                ; advance pointer to NAN
4049 36A0 20 48 35              jsr   GetChar
4050 36A3 C9 28                 cmp   #OPENPAREN
4051 36A5 D0 3E                 bne   StateBackup              ; if no '(' then leave
4052 36A7 20 48 35     z15s49   jsr   GetChar
4053 36AA 90 1C                 bcc   z15s57                   ; < '0' so check for ')'
4054 36AC C9 3A                 cmp   #COLON                   ; > '9' so junk
4055 36AE B0 35                 bcs   StateBackup
4056 36B0 29 0F                 and   #$0F                     ; mask to 0..9
4057 36B2 85 AF                 sta   STMP                     ;    and hold digit until later
4058 36B4              ;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4059 36B4              ;          ;; Multiply NaNCODE by 10 and add in next digit found.
4060 36B4              ;          ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4061 36B4 06 A5                 asl   NaNCODE                  ; * 2
4062 36B6 A5 A5                 lda   NaNCODE
4063 36B8 0A                    asl   A
4064 36B9 0A                    asl   A                        ; * 8
4065 36BA 18                    clc   
4066 36BB 65 A5                 adc   NaNCODE                  ; sum to get NaNCODE * 10
4067 36BD 18                    clc   
4068 36BE 65 AF                 adc   STMP                     ; add in next digit
4069 36C0 85 A5                 sta   NaNCODE
4070 36C2 4C A7 36              jmp   z15s49                   ; and keep looking
4071 36C5              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4072 36C5              ;       ;; End of numeric scan.  Now look for the final ')'.
4073 36C5              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4074 36C5 20 48 35              jsr   GetChar
4075 36C8 C9 29        z15s57   cmp   #CLOSEPAREN              ; end with  ')'?
4076 36CA D0 19                 bne   StateBackup              ; if no ')', back up pointer
4077 36CC              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4078 36CC              ;       ;; Process NaNCODE and put two ascii hex characters in d.sig
4079 36CC              ;       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4080 36CC A5 A5                 lda   NaNCODE
4081 36CE 4A                    lsr   A
4082 36CF 4A                    lsr   A
4083 36D0 4A                    lsr   A
4084 36D1 4A                    lsr   A
4085 36D2 20 26 37              jsr   NibOut                   ; process hi byte
4086 36D5 A0 04                 ldy   #$4                      ; {CRL19jun85} PUT NAN CODE IN RIGHT PLACE
4087 36D7 97 90                 sta   [DSIGLOC],Y              ; and store the ascii
4088 36D9 A5 A5                 lda   NaNCODE
4089 36DB 29 0F                 and   #$0F
4090 36DD 20 26 37              jsr   NibOut                   ; process lo byte
4091 36E0 C8                    iny   
4092 36E1 97 90                 sta   [DSIGLOC],Y              ; and store the ascii
4093 36E3 D0 24                 bne   INF3                     ; always
4094 36E5              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4095 36E5              ;; StateBackup -- if the string has been overscanned, then SAVEDCHARPTR
4096 36E5              ;; contains the index of the last valid substring.  In this case, revert to
4097 36E5              ;; the saved pointer and then branch to the output routine.
4098 36E5              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4099 36E5 A6 A2        StateBackup ldx   SAVEDCHARPTR
4100 36E7 86 A0                 stx   CHARPTR
4101 36E9 A6 A3                 ldx   SAVEDCHARPTR+1
4102 36EB 86 A1                 stx   CHARPTR+1
4103 36ED 4C 1D 36              jmp   StNum2                   ; always
4104 36F0              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4105 36F0              ;; StateINF -- look for simple string 'INF'.
4106 36F0              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4107 36F0 20 16 37     StateINF jsr   GetMapped
4108 36F3 C9 4E                 cmp   #N
4109 36F5 D0 EE                 bne   StateBackup
4110 36F7 20 16 37              jsr   GetMapped
4111 36FA C9 46                 cmp   #F
4112 36FC D0 E7                 bne   StateBackup
4113 36FE A0 00                 ldy   #$0
4114 3700 A9 01                 lda   #$1
4115 3702 97 90                 sta   [DSIGLOC],Y              ; length byte of 1
4116 3704 A9 49                 lda   #I                       ; put I into d.sig
4117 3706 C8                    iny   
4118 3707 97 90                 sta   [DSIGLOC],Y
4119 3709 20 2F 37     INF3     jsr   ClearSavedPtr            ; use current pointer
4120 370C 20 3F 37              jsr   CheckEndScan             ; end of scan?
4121 370F B0 02                 bcs   z16s7                    ;    if not, branch
4122 3711 E6 A7                 inc   FLVALPREF                ;    if so, set flag
4123 3713 4C 55 36     z16s7    jmp   StateFin
4124 3716              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4125 3716              ;; GetMapped -- fetches next input character, maps to upper case.  Note
4126 3716              ;; that upper and lower case letters differ only in bit #5.
4127 3716              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4128 3716 A9 04        GetMapped lda   #$4                     ; stack adjust in GetChar
4129 3718 20 4A 35              jsr   GetChar2
4130 371B C9 61                 cmp   #SMALLa
4131 371D 90 06                 bcc   z17s1                    ; too small for lower case
4132 371F C9 7B                 cmp   #zPLUS1                  ; one past 'z'
4133 3721 B0 02                 bcs   z17s1                    ; too big for lower case
4134 3723 29 DF                 and   #$0DF                    ; mask 1101 1111 for bit 5
4135 3725 60           z17s1    rts   
4136 3726              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4137 3726              ;; NibOut -- passed 2a nibble in the accumulator, construct an ascii
4138 3726              ;; character of it.
4139 3726              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4140 3726 C9 0A        NibOut   cmp   #$0a                     ;<klh 18oct85>
4141 3728 90 02                 bcc   z18s1                    ; 0..9
4142 372A 69 06                 adc   #$6                      ; A..F offset is $37 (6 + carry)
4143 372C 69 30        z18s1    adc   #$30                     ; 0..9 offset is $30
4144 372E 60                    rts   
4145 372F              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4146 372F              ;; The subroutines which control the current value of the scan pointer
4147 372F              ;;      and the current value of its backup which is used after overscanning.
4148 372F              ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
4149 372F A2 FF        ClearSavedPtr ldx   #$0FF
4150 3731 86 A2                 stx   SAVEDCHARPTR
4151 3733 86 A3                 stx   SAVEDCHARPTR+1
4152 3735 60                    RTS   
4153 3736 A6 A0        UpdatePtr ldx   CHARPTR
4154 3738 86 A2                 stx   SAVEDCHARPTR
4155 373A A6 A1                 ldx   CHARPTR+1
4156 373C 86 A3                 stx   SAVEDCHARPTR+1
4157 373E 60                    RTS   
4158 373F A6 B0        CheckEndScan ldx   CSTRING
4159 3741 F0 05                 beq   z19s3
4160 3743 A6 A4                 ldx   LASTCHARPTR
4161 3745 E4 A0                 cpx   CHARPTR
4162 3747              ;      ;JMP     $5
4163 3747 60                    rts                            ; <klh 18oct85>
4164 3748 38           z19s3    SEC   
4165 3749 A4 A0                 ldy   CHARPTR
4166 374B B7 8C                 lda   [thisS],Y
4167 374D D0 01                 bne   z19s5
4168 374F 18                    CLC   
4169 3750 60           z19s5    RTS   
4170 3751                       EXPORT SNaN 
4171 3751 00 00 00 00  SNaN     DC B:$00,$00,$00,$00,$05,$4E,$30,$30,$31,$31  ;{SNaN bit change 23May85 CRL}
4172 375B                       longa on
4173 375B                       longi on
4174 375B                       ENDP 
4175 375B
4176 375B
4177 375B
4178 375B                       END   
4179 375B
